@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Kafka RemoteBrokerConnection Sasl Authentication token properties. NOTE - Enum only one method is allowed to be passed.
 * @property keyVault Keyvault token keyvault secret properties.
 * @property secretName Secret where cert details are stored.
 */
public data class SaslRemoteBrokerBasicAuthenticationTokenResponse(
    public val keyVault: KafkaTokenKeyVaultPropertiesResponse? = null,
    public val secretName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.SaslRemoteBrokerBasicAuthenticationTokenResponse):
            SaslRemoteBrokerBasicAuthenticationTokenResponse =
            SaslRemoteBrokerBasicAuthenticationTokenResponse(
                keyVault = javaType.keyVault().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaTokenKeyVaultPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                secretName = javaType.secretName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
