@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin

import com.pulumi.azurenative.iotoperationsorchestrator.InstanceArgs.builder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ReconciliationPolicyArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ReconciliationPolicyArgsBuilder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.TargetSelectorPropertiesArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.TargetSelectorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Instance resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Instances_CreateOrUpdate - generated by [MaximumSet] rule - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instance = new AzureNative.IoTOperationsOrchestrator.Instance("instance", new()
 *     {
 *         ExtendedLocation = new AzureNative.IoTOperationsOrchestrator.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "bjjhfqsplgzdlbdlddleetyg",
 *             Type = "sosibrbmmrfbbyp",
 *         },
 *         Location = "uzehbktba",
 *         Name = "j6-r05-43h--55-q97-9ig--6w44a-2--3g-k53-13263ncl6-2q-h0-q5",
 *         ReconciliationPolicy = new AzureNative.IoTOperationsOrchestrator.Inputs.ReconciliationPolicyArgs
 *         {
 *             Interval = "wyrrzydmfgzymvzbppscxyfobku",
 *             Type = "periodic",
 *         },
 *         ResourceGroupName = "rgopenapi",
 *         Scope = "rkargnjeljnivwjly",
 *         Solution = "p",
 *         Tags = null,
 *         Target = new AzureNative.IoTOperationsOrchestrator.Inputs.TargetSelectorPropertiesArgs
 *         {
 *             Name = "mqxcv",
 *         },
 *         Version = "nf",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsorchestrator/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsorchestrator.NewInstance(ctx, "instance", &iotoperationsorchestrator.InstanceArgs{
 * 			ExtendedLocation: &iotoperationsorchestrator.ExtendedLocationArgs{
 * 				Name: pulumi.String("bjjhfqsplgzdlbdlddleetyg"),
 * 				Type: pulumi.String("sosibrbmmrfbbyp"),
 * 			},
 * 			Location: pulumi.String("uzehbktba"),
 * 			Name:     pulumi.String("j6-r05-43h--55-q97-9ig--6w44a-2--3g-k53-13263ncl6-2q-h0-q5"),
 * 			ReconciliationPolicy: &iotoperationsorchestrator.ReconciliationPolicyArgs{
 * 				Interval: pulumi.String("wyrrzydmfgzymvzbppscxyfobku"),
 * 				Type:     pulumi.String("periodic"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Scope:             pulumi.String("rkargnjeljnivwjly"),
 * 			Solution:          pulumi.String("p"),
 * 			Tags:              nil,
 * 			Target: &iotoperationsorchestrator.TargetSelectorPropertiesArgs{
 * 				Name: pulumi.String("mqxcv"),
 * 			},
 * 			Version: pulumi.String("nf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsorchestrator.Instance;
 * import com.pulumi.azurenative.iotoperationsorchestrator.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "bjjhfqsplgzdlbdlddleetyg"),
 *                 Map.entry("type", "sosibrbmmrfbbyp")
 *             ))
 *             .location("uzehbktba")
 *             .name("j6-r05-43h--55-q97-9ig--6w44a-2--3g-k53-13263ncl6-2q-h0-q5")
 *             .reconciliationPolicy(Map.ofEntries(
 *                 Map.entry("interval", "wyrrzydmfgzymvzbppscxyfobku"),
 *                 Map.entry("type", "periodic")
 *             ))
 *             .resourceGroupName("rgopenapi")
 *             .scope("rkargnjeljnivwjly")
 *             .solution("p")
 *             .tags()
 *             .target(Map.of("name", "mqxcv"))
 *             .version("nf")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsorchestrator:Instance sauintupvjhadznpynqhfjdzjgu /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsOrchestrator/instances/{name}
 * ```
 * @property extendedLocation Edge location of the resource.
 * @property location The geo-location where the resource lives
 * @property name Name of Instance.
 * @property reconciliationPolicy Reconciliation Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope Deployment scope (such as Kubernetes namespace).
 * @property solution Name of the solution.
 * @property tags Resource tags.
 * @property target Defines the Target the Instance will deploy to.
 * @property version Version of the particular resource.
 */
public data class InstanceArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val reconciliationPolicy: Output<ReconciliationPolicyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val solution: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val target: Output<TargetSelectorPropertiesArgs>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsorchestrator.InstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsorchestrator.InstanceArgs =
        com.pulumi.azurenative.iotoperationsorchestrator.InstanceArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .reconciliationPolicy(
                reconciliationPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .solution(solution?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .target(target?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var reconciliationPolicy: Output<ReconciliationPolicyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<String>? = null

    private var solution: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var target: Output<TargetSelectorPropertiesArgs>? = null

    private var version: Output<String>? = null

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("kvptknmrltwtjpgr")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("utvhxxpfymnlrnjc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of Instance.
     */
    @JvmName("hewxjqenbtqxqmur")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reconciliation Policy.
     */
    @JvmName("xrfnumtyeudgbnym")
    public suspend fun reconciliationPolicy(`value`: Output<ReconciliationPolicyArgs>) {
        this.reconciliationPolicy = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sylkdxjgqjkdxvfp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Deployment scope (such as Kubernetes namespace).
     */
    @JvmName("ckjvjudxfirelrkt")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Name of the solution.
     */
    @JvmName("orfahcfwnvlkwwva")
    public suspend fun solution(`value`: Output<String>) {
        this.solution = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wnmcwbejyuubsufl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines the Target the Instance will deploy to.
     */
    @JvmName("xjcoufxnbwbgcnmx")
    public suspend fun target(`value`: Output<TargetSelectorPropertiesArgs>) {
        this.target = value
    }

    /**
     * @param value Version of the particular resource.
     */
    @JvmName("vkvakprbetptnpsg")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("pcxvgryrwigwyfts")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Edge location of the resource.
     */
    @JvmName("bjyuvhvgfxbaamqq")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hoctexcgyoimnwap")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of Instance.
     */
    @JvmName("sdjvaluvmrbyucmi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reconciliation Policy.
     */
    @JvmName("svmirrujsuimidoj")
    public suspend fun reconciliationPolicy(`value`: ReconciliationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reconciliationPolicy = mapped
    }

    /**
     * @param argument Reconciliation Policy.
     */
    @JvmName("dsvrjqwrupbybnca")
    public suspend
    fun reconciliationPolicy(argument: suspend ReconciliationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ReconciliationPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reconciliationPolicy = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wnrryhryfevnkjmy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Deployment scope (such as Kubernetes namespace).
     */
    @JvmName("pgxaxnenoevmquqe")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Name of the solution.
     */
    @JvmName("ftstsbcqukhitgto")
    public suspend fun solution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.solution = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("refjkfkowsksyddi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ysrthfkinxfmppcc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Defines the Target the Instance will deploy to.
     */
    @JvmName("axnmytkwnhdrjfpc")
    public suspend fun target(`value`: TargetSelectorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Defines the Target the Instance will deploy to.
     */
    @JvmName("fjqfnbaglpaatuwr")
    public suspend fun target(argument: suspend TargetSelectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TargetSelectorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    /**
     * @param value Version of the particular resource.
     */
    @JvmName("hckqskyiajirflgp")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        extendedLocation = extendedLocation,
        location = location,
        name = name,
        reconciliationPolicy = reconciliationPolicy,
        resourceGroupName = resourceGroupName,
        scope = scope,
        solution = solution,
        tags = tags,
        target = target,
        version = version,
    )
}
