@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin

import com.pulumi.azurenative.iotoperationsorchestrator.TargetArgs.builder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ComponentPropertiesArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ComponentPropertiesArgsBuilder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ReconciliationPolicyArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.ReconciliationPolicyArgsBuilder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.TopologiesPropertiesArgs
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs.TopologiesPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Target resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Targets_CreateOrUpdate - generated by [MaximumSet] rule - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var target = new AzureNative.IoTOperationsOrchestrator.Target("target", new()
 *     {
 *         Components = new[]
 *         {
 *             new AzureNative.IoTOperationsOrchestrator.Inputs.ComponentPropertiesArgs
 *             {
 *                 Dependencies = new[]
 *                 {
 *                     "x",
 *                 },
 *                 Name = "yhnelpxsobdyurwvhkq",
 *                 Properties = null,
 *                 Type = "wiabwsfqhhxru",
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.IoTOperationsOrchestrator.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "bjjhfqsplgzdlbdlddleetyg",
 *             Type = "sosibrbmmrfbbyp",
 *         },
 *         Location = "pjjkifnrwvzcyohz",
 *         Name = "7---s--1-hl-fl-3f0-wfy34e08-4",
 *         ReconciliationPolicy = new AzureNative.IoTOperationsOrchestrator.Inputs.ReconciliationPolicyArgs
 *         {
 *             Interval = "wyrrzydmfgzymvzbppscxyfobku",
 *             Type = "periodic",
 *         },
 *         ResourceGroupName = "rgopenapi",
 *         Scope = "lm",
 *         Tags = null,
 *         Topologies = new[]
 *         {
 *             new AzureNative.IoTOperationsOrchestrator.Inputs.TopologiesPropertiesArgs
 *             {
 *                 Bindings = new[]
 *                 {
 *                     new AzureNative.IoTOperationsOrchestrator.Inputs.BindingPropertiesArgs
 *                     {
 *                         Config = null,
 *                         Provider = "qpwesjlyyggcbehwigbobqum",
 *                         Role = "role",
 *                     },
 *                 },
 *             },
 *         },
 *         Version = "prbigsnjltnzqliu",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsorchestrator/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsorchestrator.NewTarget(ctx, "target", &iotoperationsorchestrator.TargetArgs{
 * 			Components: []iotoperationsorchestrator.ComponentPropertiesArgs{
 * 				{
 * 					Dependencies: pulumi.StringArray{
 * 						pulumi.String("x"),
 * 					},
 * 					Name:       pulumi.String("yhnelpxsobdyurwvhkq"),
 * 					Properties: nil,
 * 					Type:       pulumi.String("wiabwsfqhhxru"),
 * 				},
 * 			},
 * 			ExtendedLocation: &iotoperationsorchestrator.ExtendedLocationArgs{
 * 				Name: pulumi.String("bjjhfqsplgzdlbdlddleetyg"),
 * 				Type: pulumi.String("sosibrbmmrfbbyp"),
 * 			},
 * 			Location: pulumi.String("pjjkifnrwvzcyohz"),
 * 			Name:     pulumi.String("7---s--1-hl-fl-3f0-wfy34e08-4"),
 * 			ReconciliationPolicy: &iotoperationsorchestrator.ReconciliationPolicyArgs{
 * 				Interval: pulumi.String("wyrrzydmfgzymvzbppscxyfobku"),
 * 				Type:     pulumi.String("periodic"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Scope:             pulumi.String("lm"),
 * 			Tags:              nil,
 * 			Topologies: []iotoperationsorchestrator.TopologiesPropertiesArgs{
 * 				{
 * 					Bindings: iotoperationsorchestrator.BindingPropertiesArray{
 * 						{
 * 							Config:   nil,
 * 							Provider: pulumi.String("qpwesjlyyggcbehwigbobqum"),
 * 							Role:     pulumi.String("role"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Version: pulumi.String("prbigsnjltnzqliu"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsorchestrator.Target;
 * import com.pulumi.azurenative.iotoperationsorchestrator.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var target = new Target("target", TargetArgs.builder()
 *             .components(Map.ofEntries(
 *                 Map.entry("dependencies", "x"),
 *                 Map.entry("name", "yhnelpxsobdyurwvhkq"),
 *                 Map.entry("properties", ),
 *                 Map.entry("type", "wiabwsfqhhxru")
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "bjjhfqsplgzdlbdlddleetyg"),
 *                 Map.entry("type", "sosibrbmmrfbbyp")
 *             ))
 *             .location("pjjkifnrwvzcyohz")
 *             .name("7---s--1-hl-fl-3f0-wfy34e08-4")
 *             .reconciliationPolicy(Map.ofEntries(
 *                 Map.entry("interval", "wyrrzydmfgzymvzbppscxyfobku"),
 *                 Map.entry("type", "periodic")
 *             ))
 *             .resourceGroupName("rgopenapi")
 *             .scope("lm")
 *             .tags()
 *             .topologies(Map.of("bindings", Map.ofEntries(
 *                 Map.entry("config", ),
 *                 Map.entry("provider", "qpwesjlyyggcbehwigbobqum"),
 *                 Map.entry("role", "role")
 *             )))
 *             .version("prbigsnjltnzqliu")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsorchestrator:Target lrhoqxofrfoihqxmmxadhxeqzsnepc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsOrchestrator/targets/{name}
 * ```
 * @property components A list of components.
 * @property extendedLocation Edge location of the resource.
 * @property location The geo-location where the resource lives
 * @property name Name of target.
 * @property reconciliationPolicy Reconciliation Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope Deployment scope (such as Kubernetes namespace).
 * @property tags Resource tags.
 * @property topologies Defines the device topology for a target or instance.
 * @property version Version of the particular resource.
 */
public data class TargetArgs(
    public val components: Output<List<ComponentPropertiesArgs>>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val reconciliationPolicy: Output<ReconciliationPolicyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topologies: Output<List<TopologiesPropertiesArgs>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsorchestrator.TargetArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsorchestrator.TargetArgs =
        com.pulumi.azurenative.iotoperationsorchestrator.TargetArgs.builder()
            .components(
                components?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .reconciliationPolicy(
                reconciliationPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topologies(
                topologies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetArgs].
 */
@PulumiTagMarker
public class TargetArgsBuilder internal constructor() {
    private var components: Output<List<ComponentPropertiesArgs>>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var reconciliationPolicy: Output<ReconciliationPolicyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topologies: Output<List<TopologiesPropertiesArgs>>? = null

    private var version: Output<String>? = null

    /**
     * @param value A list of components.
     */
    @JvmName("egxpehnlpfhrhqfx")
    public suspend fun components(`value`: Output<List<ComponentPropertiesArgs>>) {
        this.components = value
    }

    @JvmName("btoifejevkmybjjb")
    public suspend fun components(vararg values: Output<ComponentPropertiesArgs>) {
        this.components = Output.all(values.asList())
    }

    /**
     * @param values A list of components.
     */
    @JvmName("yoimfajjdbljhuvx")
    public suspend fun components(values: List<Output<ComponentPropertiesArgs>>) {
        this.components = Output.all(values)
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("adgtteovitokfmdf")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bmpmiumbitlhchru")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of target.
     */
    @JvmName("ibfnimnmwhlurmlx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reconciliation Policy.
     */
    @JvmName("cgdwxomxmnsemlkq")
    public suspend fun reconciliationPolicy(`value`: Output<ReconciliationPolicyArgs>) {
        this.reconciliationPolicy = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kmuefimgxdypjypt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Deployment scope (such as Kubernetes namespace).
     */
    @JvmName("xodnyxkociscnriq")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oaelocmmgkvpvtie")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines the device topology for a target or instance.
     */
    @JvmName("vvarlrqnelujeymg")
    public suspend fun topologies(`value`: Output<List<TopologiesPropertiesArgs>>) {
        this.topologies = value
    }

    @JvmName("mdsdgdiivltluylc")
    public suspend fun topologies(vararg values: Output<TopologiesPropertiesArgs>) {
        this.topologies = Output.all(values.asList())
    }

    /**
     * @param values Defines the device topology for a target or instance.
     */
    @JvmName("plhwvossstugoiav")
    public suspend fun topologies(values: List<Output<TopologiesPropertiesArgs>>) {
        this.topologies = Output.all(values)
    }

    /**
     * @param value Version of the particular resource.
     */
    @JvmName("dadmemtgbpvjoqmg")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value A list of components.
     */
    @JvmName("kcryogfoxdjsiuhc")
    public suspend fun components(`value`: List<ComponentPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param argument A list of components.
     */
    @JvmName("lfdmyntkbhcjpjks")
    public suspend fun components(argument: List<suspend ComponentPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ComponentPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument A list of components.
     */
    @JvmName("vxuxxwnfdcbncuaf")
    public suspend fun components(
        vararg
        argument: suspend ComponentPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ComponentPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument A list of components.
     */
    @JvmName("cemxernkejmmxkqo")
    public suspend fun components(argument: suspend ComponentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ComponentPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param values A list of components.
     */
    @JvmName("gavyisdqfjubrsbd")
    public suspend fun components(vararg values: ComponentPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("hijnepmgphbonfje")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Edge location of the resource.
     */
    @JvmName("akejaucmpfywcklf")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vqpxwmsdbycsnbsq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of target.
     */
    @JvmName("nsymxgjabuoxtyam")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reconciliation Policy.
     */
    @JvmName("ksyctybylynqgiah")
    public suspend fun reconciliationPolicy(`value`: ReconciliationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reconciliationPolicy = mapped
    }

    /**
     * @param argument Reconciliation Policy.
     */
    @JvmName("vhrwdfnhteujcbuh")
    public suspend
    fun reconciliationPolicy(argument: suspend ReconciliationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ReconciliationPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reconciliationPolicy = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iqjwdgcgigpjtlfs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Deployment scope (such as Kubernetes namespace).
     */
    @JvmName("qluqxtepclahecyi")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iwtlymeykhstmjwc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("agrhqkklftjvqypl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Defines the device topology for a target or instance.
     */
    @JvmName("qipcpnhtmbhxfvut")
    public suspend fun topologies(`value`: List<TopologiesPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topologies = mapped
    }

    /**
     * @param argument Defines the device topology for a target or instance.
     */
    @JvmName("wokdmsripoxbyuvl")
    public suspend
    fun topologies(argument: List<suspend TopologiesPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TopologiesPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.topologies = mapped
    }

    /**
     * @param argument Defines the device topology for a target or instance.
     */
    @JvmName("ubhjrfswbljgrkej")
    public suspend fun topologies(
        vararg
        argument: suspend TopologiesPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TopologiesPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.topologies = mapped
    }

    /**
     * @param argument Defines the device topology for a target or instance.
     */
    @JvmName("wtlpuxowrlsxfehu")
    public suspend fun topologies(argument: suspend TopologiesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TopologiesPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.topologies = mapped
    }

    /**
     * @param values Defines the device topology for a target or instance.
     */
    @JvmName("qcjbhfmnwtfspggq")
    public suspend fun topologies(vararg values: TopologiesPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topologies = mapped
    }

    /**
     * @param value Version of the particular resource.
     */
    @JvmName("gllvtcqhydolrwgg")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): TargetArgs = TargetArgs(
        components = components,
        extendedLocation = extendedLocation,
        location = location,
        name = name,
        reconciliationPolicy = reconciliationPolicy,
        resourceGroupName = resourceGroupName,
        scope = scope,
        tags = tags,
        topologies = topologies,
        version = version,
    )
}
