@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs

import com.pulumi.azurenative.iotoperationsorchestrator.inputs.ComponentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a desired runtime component.
 * @property dependencies Component dependencies.
 * @property name Name of the component.
 * @property properties Properties of the component.
 * @property type Component type.
 */
public data class ComponentPropertiesArgs(
    public val dependencies: Output<List<String>>? = null,
    public val name: Output<String>,
    public val properties: Output<Any>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsorchestrator.inputs.ComponentPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.ComponentPropertiesArgs =
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.ComponentPropertiesArgs.builder()
            .dependencies(dependencies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComponentPropertiesArgs].
 */
@PulumiTagMarker
public class ComponentPropertiesArgsBuilder internal constructor() {
    private var dependencies: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var properties: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Component dependencies.
     */
    @JvmName("ocmusjheublyklef")
    public suspend fun dependencies(`value`: Output<List<String>>) {
        this.dependencies = value
    }

    @JvmName("rdyircmissjokrcd")
    public suspend fun dependencies(vararg values: Output<String>) {
        this.dependencies = Output.all(values.asList())
    }

    /**
     * @param values Component dependencies.
     */
    @JvmName("atrnijuwmmxlldxe")
    public suspend fun dependencies(values: List<Output<String>>) {
        this.dependencies = Output.all(values)
    }

    /**
     * @param value Name of the component.
     */
    @JvmName("cikayylcsfvrsblg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Properties of the component.
     */
    @JvmName("tmyalswlysywhfvr")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value Component type.
     */
    @JvmName("waxvkcflkmhjaffk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Component dependencies.
     */
    @JvmName("rtfmacledltchphn")
    public suspend fun dependencies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependencies = mapped
    }

    /**
     * @param values Component dependencies.
     */
    @JvmName("lpjvugjtefykacal")
    public suspend fun dependencies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependencies = mapped
    }

    /**
     * @param value Name of the component.
     */
    @JvmName("ktlkaombgmgongtr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Properties of the component.
     */
    @JvmName("dimsmxytbvmremad")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Component type.
     */
    @JvmName("hhpyksyyobjpqcem")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ComponentPropertiesArgs = ComponentPropertiesArgs(
        dependencies = dependencies,
        name = name ?: throw PulumiNullFieldException("name"),
        properties = properties,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
