@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs

import com.pulumi.azurenative.iotoperationsorchestrator.inputs.TopologiesPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a desired runtime component.
 * @property bindings bindings description.
 */
public data class TopologiesPropertiesArgs(
    public val bindings: Output<List<BindingPropertiesArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsorchestrator.inputs.TopologiesPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.TopologiesPropertiesArgs =
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.TopologiesPropertiesArgs.builder()
            .bindings(
                bindings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TopologiesPropertiesArgs].
 */
@PulumiTagMarker
public class TopologiesPropertiesArgsBuilder internal constructor() {
    private var bindings: Output<List<BindingPropertiesArgs>>? = null

    /**
     * @param value bindings description.
     */
    @JvmName("pormvohacvwnraby")
    public suspend fun bindings(`value`: Output<List<BindingPropertiesArgs>>) {
        this.bindings = value
    }

    @JvmName("dndmwunkxjlhhfqy")
    public suspend fun bindings(vararg values: Output<BindingPropertiesArgs>) {
        this.bindings = Output.all(values.asList())
    }

    /**
     * @param values bindings description.
     */
    @JvmName("ysugdrjvptxjjlhk")
    public suspend fun bindings(values: List<Output<BindingPropertiesArgs>>) {
        this.bindings = Output.all(values)
    }

    /**
     * @param value bindings description.
     */
    @JvmName("wkboaucgpdrotxox")
    public suspend fun bindings(`value`: List<BindingPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param argument bindings description.
     */
    @JvmName("ptlrmypbsigbimjs")
    public suspend fun bindings(argument: List<suspend BindingPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BindingPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument bindings description.
     */
    @JvmName("vrdfaebuyoxyfrvq")
    public suspend fun bindings(vararg argument: suspend BindingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BindingPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument bindings description.
     */
    @JvmName("rihgxvqilmrfrnts")
    public suspend fun bindings(argument: suspend BindingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BindingPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param values bindings description.
     */
    @JvmName("ytwtqxsadcbritem")
    public suspend fun bindings(vararg values: BindingPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    internal fun build(): TopologiesPropertiesArgs = TopologiesPropertiesArgs(
        bindings = bindings,
    )
}
