@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a desired runtime component.
 * @property dependencies Component dependencies.
 * @property name Name of the component.
 * @property properties Properties of the component.
 * @property type Component type.
 */
public data class ComponentPropertiesResponse(
    public val dependencies: List<String>? = null,
    public val name: String,
    public val properties: Any? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsorchestrator.outputs.ComponentPropertiesResponse):
            ComponentPropertiesResponse = ComponentPropertiesResponse(
            dependencies = javaType.dependencies().map({ args0 -> args0 }),
            name = javaType.name(),
            properties = javaType.properties().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
