@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The vault's create mode to indicate whether the vault need to be recovered or not.
 */
public enum class CreateMode(
    public val javaValue: com.pulumi.azurenative.keyvault.enums.CreateMode,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.enums.CreateMode> {
    Recover(com.pulumi.azurenative.keyvault.enums.CreateMode.Recover),
    Default_(com.pulumi.azurenative.keyvault.enums.CreateMode.Default_),
    ;

    override fun toJava(): com.pulumi.azurenative.keyvault.enums.CreateMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.enums.CreateMode): CreateMode =
            CreateMode.values().first { it.javaValue == javaType }
    }
}
