@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The permitted JSON web key operations of the key. For more information, see JsonWebKeyOperation.
 */
public enum class JsonWebKeyOperation(
    public val javaValue: com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation> {
    Encrypt(com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation.Encrypt),
    Decrypt(com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation.Decrypt),
    Sign(com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation.Sign),
    Verify(com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation.Verify),
    WrapKey(com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation.WrapKey),
    UnwrapKey(com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation.UnwrapKey),
    Import_(com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation.Import_),
    Release(com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation.Release),
    ;

    override fun toJava(): com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.enums.JsonWebKeyOperation):
            JsonWebKeyOperation = JsonWebKeyOperation.values().first { it.javaValue == javaType }
    }
}
