@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
 */
public enum class NetworkRuleAction(
    public val javaValue: com.pulumi.azurenative.keyvault.enums.NetworkRuleAction,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.enums.NetworkRuleAction> {
    Allow(com.pulumi.azurenative.keyvault.enums.NetworkRuleAction.Allow),
    Deny(com.pulumi.azurenative.keyvault.enums.NetworkRuleAction.Deny),
    ;

    override fun toJava(): com.pulumi.azurenative.keyvault.enums.NetworkRuleAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.enums.NetworkRuleAction):
            NetworkRuleAction = NetworkRuleAction.values().first { it.javaValue == javaType }
    }
}
