@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.KeyPropertiesArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.JsonWebKeyCurveName
import com.pulumi.azurenative.keyvault.kotlin.enums.JsonWebKeyOperation
import com.pulumi.azurenative.keyvault.kotlin.enums.JsonWebKeyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of the key.
 * @property attributes The attributes of the key.
 * @property curveName The elliptic curve name. For valid values, see JsonWebKeyCurveName.
 * @property keyOps
 * @property keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
 * @property kty The type of the key. For valid values, see JsonWebKeyType.
 * @property releasePolicy Key release policy in response. It will be used for both output and input. Omitted if empty
 * @property rotationPolicy Key rotation policy in response. It will be used for both output and input. Omitted if empty
 */
public data class KeyPropertiesArgs(
    public val attributes: Output<KeyAttributesArgs>? = null,
    public val curveName: Output<Either<String, JsonWebKeyCurveName>>? = null,
    public val keyOps: Output<List<Either<String, JsonWebKeyOperation>>>? = null,
    public val keySize: Output<Int>? = null,
    public val kty: Output<Either<String, JsonWebKeyType>>? = null,
    public val releasePolicy: Output<KeyReleasePolicyArgs>? = null,
    public val rotationPolicy: Output<RotationPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.KeyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.KeyPropertiesArgs =
        com.pulumi.azurenative.keyvault.inputs.KeyPropertiesArgs.builder()
            .attributes(attributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .curveName(
                curveName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyOps(
                keyOps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .keySize(keySize?.applyValue({ args0 -> args0 }))
            .kty(
                kty?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .releasePolicy(releasePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rotationPolicy(
                rotationPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [KeyPropertiesArgs].
 */
@PulumiTagMarker
public class KeyPropertiesArgsBuilder internal constructor() {
    private var attributes: Output<KeyAttributesArgs>? = null

    private var curveName: Output<Either<String, JsonWebKeyCurveName>>? = null

    private var keyOps: Output<List<Either<String, JsonWebKeyOperation>>>? = null

    private var keySize: Output<Int>? = null

    private var kty: Output<Either<String, JsonWebKeyType>>? = null

    private var releasePolicy: Output<KeyReleasePolicyArgs>? = null

    private var rotationPolicy: Output<RotationPolicyArgs>? = null

    /**
     * @param value The attributes of the key.
     */
    @JvmName("dnmcjbxmoclsudmx")
    public suspend fun attributes(`value`: Output<KeyAttributesArgs>) {
        this.attributes = value
    }

    /**
     * @param value The elliptic curve name. For valid values, see JsonWebKeyCurveName.
     */
    @JvmName("mbdhbnakjltwvrjo")
    public suspend fun curveName(`value`: Output<Either<String, JsonWebKeyCurveName>>) {
        this.curveName = value
    }

    /**
     * @param value
     */
    @JvmName("mxajydwfjfxjwpdm")
    public suspend fun keyOps(`value`: Output<List<Either<String, JsonWebKeyOperation>>>) {
        this.keyOps = value
    }

    @JvmName("ghhqumdayjnkjywg")
    public suspend fun keyOps(vararg values: Output<Either<String, JsonWebKeyOperation>>) {
        this.keyOps = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yxxrsykhxculdmeq")
    public suspend fun keyOps(values: List<Output<Either<String, JsonWebKeyOperation>>>) {
        this.keyOps = Output.all(values)
    }

    /**
     * @param value The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     */
    @JvmName("fmrpadlmhpbmegno")
    public suspend fun keySize(`value`: Output<Int>) {
        this.keySize = value
    }

    /**
     * @param value The type of the key. For valid values, see JsonWebKeyType.
     */
    @JvmName("mvblxyftwuhxwnid")
    public suspend fun kty(`value`: Output<Either<String, JsonWebKeyType>>) {
        this.kty = value
    }

    /**
     * @param value Key release policy in response. It will be used for both output and input. Omitted if empty
     */
    @JvmName("lvxumouxvesbstpl")
    public suspend fun releasePolicy(`value`: Output<KeyReleasePolicyArgs>) {
        this.releasePolicy = value
    }

    /**
     * @param value Key rotation policy in response. It will be used for both output and input. Omitted if empty
     */
    @JvmName("gxnpojraigujravh")
    public suspend fun rotationPolicy(`value`: Output<RotationPolicyArgs>) {
        this.rotationPolicy = value
    }

    /**
     * @param value The attributes of the key.
     */
    @JvmName("hwtghinlrircaorl")
    public suspend fun attributes(`value`: KeyAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument The attributes of the key.
     */
    @JvmName("ofsaxvpkwcfwgjlj")
    public suspend fun attributes(argument: suspend KeyAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param value The elliptic curve name. For valid values, see JsonWebKeyCurveName.
     */
    @JvmName("camijeolmfuccjqf")
    public suspend fun curveName(`value`: Either<String, JsonWebKeyCurveName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.curveName = mapped
    }

    /**
     * @param value The elliptic curve name. For valid values, see JsonWebKeyCurveName.
     */
    @JvmName("xmeweuwbsxmgovho")
    public fun curveName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JsonWebKeyCurveName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.curveName = mapped
    }

    /**
     * @param value The elliptic curve name. For valid values, see JsonWebKeyCurveName.
     */
    @JvmName("ewvcmjukmuphsubq")
    public fun curveName(`value`: JsonWebKeyCurveName) {
        val toBeMapped = Either.ofRight<String, JsonWebKeyCurveName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.curveName = mapped
    }

    /**
     * @param value
     */
    @JvmName("cilpihvawtgynate")
    public suspend fun keyOps(`value`: List<Either<String, JsonWebKeyOperation>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyOps = mapped
    }

    /**
     * @param values
     */
    @JvmName("qchfhsumauhidiey")
    public suspend fun keyOps(vararg values: Either<String, JsonWebKeyOperation>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyOps = mapped
    }

    /**
     * @param value The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     */
    @JvmName("ulvfipyimcrfbltq")
    public suspend fun keySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySize = mapped
    }

    /**
     * @param value The type of the key. For valid values, see JsonWebKeyType.
     */
    @JvmName("enpmwpqmfttnuogh")
    public suspend fun kty(`value`: Either<String, JsonWebKeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kty = mapped
    }

    /**
     * @param value The type of the key. For valid values, see JsonWebKeyType.
     */
    @JvmName("rwattcwrtiutlpyy")
    public fun kty(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JsonWebKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kty = mapped
    }

    /**
     * @param value The type of the key. For valid values, see JsonWebKeyType.
     */
    @JvmName("ssmsrqhugbwqjmox")
    public fun kty(`value`: JsonWebKeyType) {
        val toBeMapped = Either.ofRight<String, JsonWebKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kty = mapped
    }

    /**
     * @param value Key release policy in response. It will be used for both output and input. Omitted if empty
     */
    @JvmName("kbvmpnsjwlqjptlk")
    public suspend fun releasePolicy(`value`: KeyReleasePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releasePolicy = mapped
    }

    /**
     * @param argument Key release policy in response. It will be used for both output and input. Omitted if empty
     */
    @JvmName("wfrftuhknbiebymh")
    public suspend fun releasePolicy(argument: suspend KeyReleasePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = KeyReleasePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.releasePolicy = mapped
    }

    /**
     * @param value Key rotation policy in response. It will be used for both output and input. Omitted if empty
     */
    @JvmName("mktofnpmoftcwwmj")
    public suspend fun rotationPolicy(`value`: RotationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotationPolicy = mapped
    }

    /**
     * @param argument Key rotation policy in response. It will be used for both output and input. Omitted if empty
     */
    @JvmName("qnlqumgdskbmaajb")
    public suspend fun rotationPolicy(argument: suspend RotationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RotationPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rotationPolicy = mapped
    }

    internal fun build(): KeyPropertiesArgs = KeyPropertiesArgs(
        attributes = attributes,
        curveName = curveName,
        keyOps = keyOps,
        keySize = keySize,
        kty = kty,
        releasePolicy = releasePolicy,
        rotationPolicy = rotationPolicy,
    )
}
