@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.KeyReleasePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentType Content type and version of key release policy
 * @property data Blob encoding the policy rules under which the key can be released.
 */
public data class KeyReleasePolicyArgs(
    public val contentType: Output<String>? = null,
    public val `data`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.KeyReleasePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.KeyReleasePolicyArgs =
        com.pulumi.azurenative.keyvault.inputs.KeyReleasePolicyArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .`data`(`data`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyReleasePolicyArgs].
 */
@PulumiTagMarker
public class KeyReleasePolicyArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var `data`: Output<String>? = null

    /**
     * @param value Content type and version of key release policy
     */
    @JvmName("jevgsbmngedhwvto")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Blob encoding the policy rules under which the key can be released.
     */
    @JvmName("dmrxifmiwvefobnc")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Content type and version of key release policy
     */
    @JvmName("rllltrmvwryyljhq")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Blob encoding the policy rules under which the key can be released.
     */
    @JvmName("xgruvsjkbacdubdl")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    internal fun build(): KeyReleasePolicyArgs = KeyReleasePolicyArgs(
        contentType = contentType,
        `data` = `data`,
    )
}
