@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.MHSMGeoReplicatedRegionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A region that this managed HSM Pool has been extended to.
 * @property isPrimary A boolean value that indicates whether the region is the primary region or a secondary region.
 * @property name Name of the geo replicated region.
 */
public data class MHSMGeoReplicatedRegionArgs(
    public val isPrimary: Output<Boolean>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.MHSMGeoReplicatedRegionArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.MHSMGeoReplicatedRegionArgs =
        com.pulumi.azurenative.keyvault.inputs.MHSMGeoReplicatedRegionArgs.builder()
            .isPrimary(isPrimary?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MHSMGeoReplicatedRegionArgs].
 */
@PulumiTagMarker
public class MHSMGeoReplicatedRegionArgsBuilder internal constructor() {
    private var isPrimary: Output<Boolean>? = null

    private var name: Output<String>? = null

    /**
     * @param value A boolean value that indicates whether the region is the primary region or a secondary region.
     */
    @JvmName("woberbtubjkshgdq")
    public suspend fun isPrimary(`value`: Output<Boolean>) {
        this.isPrimary = value
    }

    /**
     * @param value Name of the geo replicated region.
     */
    @JvmName("qhbvssfjduasmseq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A boolean value that indicates whether the region is the primary region or a secondary region.
     */
    @JvmName("ihxodbbnwkfkpmrb")
    public suspend fun isPrimary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPrimary = mapped
    }

    /**
     * @param value Name of the geo replicated region.
     */
    @JvmName("vkcmftrgnurbvahw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): MHSMGeoReplicatedRegionArgs = MHSMGeoReplicatedRegionArgs(
        isPrimary = isPrimary,
        name = name,
    )
}
