@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.ManagedHsmSkuArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.ManagedHsmSkuFamily
import com.pulumi.azurenative.keyvault.kotlin.enums.ManagedHsmSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU details
 * @property family SKU Family of the managed HSM Pool
 * @property name SKU of the managed HSM Pool
 */
public data class ManagedHsmSkuArgs(
    public val family: Output<Either<String, ManagedHsmSkuFamily>>,
    public val name: Output<ManagedHsmSkuName>,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.ManagedHsmSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.ManagedHsmSkuArgs =
        com.pulumi.azurenative.keyvault.inputs.ManagedHsmSkuArgs.builder()
            .family(
                family.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagedHsmSkuArgs].
 */
@PulumiTagMarker
public class ManagedHsmSkuArgsBuilder internal constructor() {
    private var family: Output<Either<String, ManagedHsmSkuFamily>>? = null

    private var name: Output<ManagedHsmSkuName>? = null

    /**
     * @param value SKU Family of the managed HSM Pool
     */
    @JvmName("qxpkegfoxliabdla")
    public suspend fun family(`value`: Output<Either<String, ManagedHsmSkuFamily>>) {
        this.family = value
    }

    /**
     * @param value SKU of the managed HSM Pool
     */
    @JvmName("pjddjhrdgyncfllo")
    public suspend fun name(`value`: Output<ManagedHsmSkuName>) {
        this.name = value
    }

    /**
     * @param value SKU Family of the managed HSM Pool
     */
    @JvmName("btrhkbbebuoibrgn")
    public suspend fun family(`value`: Either<String, ManagedHsmSkuFamily>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value SKU Family of the managed HSM Pool
     */
    @JvmName("cgfhpjttmkjgsbyn")
    public fun family(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedHsmSkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value SKU Family of the managed HSM Pool
     */
    @JvmName("iegcfipednibachm")
    public fun family(`value`: ManagedHsmSkuFamily) {
        val toBeMapped = Either.ofRight<String, ManagedHsmSkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value SKU of the managed HSM Pool
     */
    @JvmName("olvlibbpefbtcxgb")
    public suspend fun name(`value`: ManagedHsmSkuName) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ManagedHsmSkuArgs = ManagedHsmSkuArgs(
        family = family ?: throw PulumiNullFieldException("family"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
