@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.VirtualNetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A rule governing the accessibility of a vault from a specific virtual network.
 * @property id Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
 * @property ignoreMissingVnetServiceEndpoint Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
 */
public data class VirtualNetworkRuleArgs(
    public val id: Output<String>,
    public val ignoreMissingVnetServiceEndpoint: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.VirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.VirtualNetworkRuleArgs =
        com.pulumi.azurenative.keyvault.inputs.VirtualNetworkRuleArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .ignoreMissingVnetServiceEndpoint(
                ignoreMissingVnetServiceEndpoint?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkRuleArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var ignoreMissingVnetServiceEndpoint: Output<Boolean>? = null

    /**
     * @param value Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     */
    @JvmName("kpgenehgpfdrotpx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
     */
    @JvmName("xvtsflyxgpvhpvjb")
    public suspend fun ignoreMissingVnetServiceEndpoint(`value`: Output<Boolean>) {
        this.ignoreMissingVnetServiceEndpoint = value
    }

    /**
     * @param value Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     */
    @JvmName("aowlksxbrdrhnmre")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
     */
    @JvmName("xsghvfclxigtrymn")
    public suspend fun ignoreMissingVnetServiceEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreMissingVnetServiceEndpoint = mapped
    }

    internal fun build(): VirtualNetworkRuleArgs = VirtualNetworkRuleArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        ignoreMissingVnetServiceEndpoint = ignoreMissingVnetServiceEndpoint,
    )
}
