@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The key resource.
 * @property attributes The attributes of the key.
 * @property curveName The elliptic curve name. For valid values, see JsonWebKeyCurveName.
 * @property id Fully qualified identifier of the key vault resource.
 * @property keyOps
 * @property keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
 * @property keyUri The URI to retrieve the current version of the key.
 * @property keyUriWithVersion The URI to retrieve the specific version of the key.
 * @property kty The type of the key. For valid values, see JsonWebKeyType.
 * @property location Azure location of the key vault resource.
 * @property name Name of the key vault resource.
 * @property releasePolicy Key release policy in response. It will be used for both output and input. Omitted if empty
 * @property rotationPolicy Key rotation policy in response. It will be used for both output and input. Omitted if empty
 * @property tags Tags assigned to the key vault resource.
 * @property type Resource type of the key vault resource.
 */
public data class GetKeyResult(
    public val attributes: KeyAttributesResponse? = null,
    public val curveName: String? = null,
    public val id: String,
    public val keyOps: List<String>? = null,
    public val keySize: Int? = null,
    public val keyUri: String,
    public val keyUriWithVersion: String,
    public val kty: String? = null,
    public val location: String,
    public val name: String,
    public val releasePolicy: KeyReleasePolicyResponse? = null,
    public val rotationPolicy: RotationPolicyResponse? = null,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.GetKeyResult):
            GetKeyResult = GetKeyResult(
            attributes = javaType.attributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.KeyAttributesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            curveName = javaType.curveName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            keyOps = javaType.keyOps().map({ args0 -> args0 }),
            keySize = javaType.keySize().map({ args0 -> args0 }).orElse(null),
            keyUri = javaType.keyUri(),
            keyUriWithVersion = javaType.keyUriWithVersion(),
            kty = javaType.kty().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            releasePolicy = javaType.releasePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.KeyReleasePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rotationPolicy = javaType.rotationPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.RotationPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
