@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Private endpoint connection resource.
 * @property etag Modified whenever there is a change in the state of private endpoint connection.
 * @property id Fully qualified identifier of the key vault resource.
 * @property location Azure location of the key vault resource.
 * @property name Name of the key vault resource.
 * @property privateEndpoint Properties of the private endpoint object.
 * @property privateLinkServiceConnectionState Approval state of the private link connection.
 * @property provisioningState Provisioning state of the private endpoint connection.
 * @property tags Tags assigned to the key vault resource.
 * @property type Resource type of the key vault resource.
 */
public data class GetPrivateEndpointConnectionResult(
    public val etag: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.GetPrivateEndpointConnectionResult):
            GetPrivateEndpointConnectionResult = GetPrivateEndpointConnectionResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
