@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * The secret management attributes.
 * @property created Creation time in seconds since 1970-01-01T00:00:00Z.
 * @property enabled Determines whether the object is enabled.
 * @property expires Expiry date in seconds since 1970-01-01T00:00:00Z.
 * @property notBefore Not before date in seconds since 1970-01-01T00:00:00Z.
 * @property updated Last updated time in seconds since 1970-01-01T00:00:00Z.
 */
public data class SecretAttributesResponse(
    public val created: Int,
    public val enabled: Boolean? = null,
    public val expires: Int? = null,
    public val notBefore: Int? = null,
    public val updated: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.SecretAttributesResponse):
            SecretAttributesResponse = SecretAttributesResponse(
            created = javaType.created(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            expires = javaType.expires().map({ args0 -> args0 }).orElse(null),
            notBefore = javaType.notBefore().map({ args0 -> args0 }).orElse(null),
            updated = javaType.updated(),
        )
    }
}
