@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the vault
 * @property accessPolicies An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
 * @property enablePurgeProtection Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
 * @property enableRbacAuthorization Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored. When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the vault is created with the default value of false. Note that management actions are always authorized with RBAC.
 * @property enableSoftDelete Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true or false) when creating new key vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
 * @property enabledForDeployment Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
 * @property enabledForDiskEncryption Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
 * @property enabledForTemplateDeployment Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
 * @property hsmPoolResourceId The resource id of HSM Pool.
 * @property networkAcls Rules governing the accessibility of the key vault from specific network locations.
 * @property privateEndpointConnections List of private endpoint connections associated with the key vault.
 * @property provisioningState Provisioning state of the vault.
 * @property publicNetworkAccess Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except private endpoint traffic and that that originates from trusted services will be blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor the rules.
 * @property sku SKU details
 * @property softDeleteRetentionInDays softDelete data retention days. It accepts >=7 and <=90.
 * @property tenantId The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
 * @property vaultUri The URI of the vault for performing operations on keys and secrets.
 */
public data class VaultPropertiesResponse(
    public val accessPolicies: List<AccessPolicyEntryResponse>? = null,
    public val enablePurgeProtection: Boolean? = null,
    public val enableRbacAuthorization: Boolean? = null,
    public val enableSoftDelete: Boolean? = null,
    public val enabledForDeployment: Boolean? = null,
    public val enabledForDiskEncryption: Boolean? = null,
    public val enabledForTemplateDeployment: Boolean? = null,
    public val hsmPoolResourceId: String,
    public val networkAcls: NetworkRuleSetResponse? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionItemResponse>,
    public val provisioningState: String? = null,
    public val publicNetworkAccess: String? = null,
    public val sku: SkuResponse,
    public val softDeleteRetentionInDays: Int? = null,
    public val tenantId: String,
    public val vaultUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.VaultPropertiesResponse):
            VaultPropertiesResponse = VaultPropertiesResponse(
            accessPolicies = javaType.accessPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.AccessPolicyEntryResponse.Companion.toKotlin(args0)
                })
            }),
            enablePurgeProtection = javaType.enablePurgeProtection().map({ args0 -> args0 }).orElse(null),
            enableRbacAuthorization = javaType.enableRbacAuthorization().map({ args0 -> args0 }).orElse(null),
            enableSoftDelete = javaType.enableSoftDelete().map({ args0 -> args0 }).orElse(null),
            enabledForDeployment = javaType.enabledForDeployment().map({ args0 -> args0 }).orElse(null),
            enabledForDiskEncryption = javaType.enabledForDiskEncryption().map({ args0 -> args0 }).orElse(null),
            enabledForTemplateDeployment = javaType.enabledForTemplateDeployment().map({ args0 ->
                args0
            }).orElse(null),
            hsmPoolResourceId = javaType.hsmPoolResourceId(),
            networkAcls = javaType.networkAcls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.PrivateEndpointConnectionItemResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.keyvault.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            softDeleteRetentionInDays = javaType.softDeleteRetentionInDays().map({ args0 ->
                args0
            }).orElse(null),
            tenantId = javaType.tenantId(),
            vaultUri = javaType.vaultUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
