@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kotlin

import com.pulumi.azurenative.ProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The provider type for the native Azure package.
 * @property auxiliaryTenantIds Any additional Tenant IDs which should be used for authentication.
 * @property clientCertificatePassword The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate
 * @property clientCertificatePath The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate.
 * @property clientId The Client ID which should be used.
 * @property clientSecret The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
 * @property disablePulumiPartnerId This will disable the Pulumi Partner ID which is used if a custom `partnerId` isn't specified.
 * @property environment The Cloud Environment which should be used. Possible values are public, usgovernment, german, and china. Defaults to public.
 * @property msiEndpoint The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected automatically.
 * @property oidcRequestToken Your provider’s token to exchange for an OIDC token.
 * @property oidcRequestUrl The URL to initiate the `oidcRequestToken` OIDC token exchange.
 * @property oidcToken The OIDC token to exchange for an Azure token.
 * @property partnerId A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
 * @property subscriptionId The Subscription ID which should be used.
 * @property tenantId The Tenant ID which should be used.
 * @property useMsi Allow Managed Service Identity to be used for Authentication.
 * @property useOidc Allow OpenID Connect (OIDC) to be used for Authentication.
 */
public data class ProviderArgs(
    public val auxiliaryTenantIds: Output<List<String>>? = null,
    public val clientCertificatePassword: Output<String>? = null,
    public val clientCertificatePath: Output<String>? = null,
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val disablePulumiPartnerId: Output<Boolean>? = null,
    public val environment: Output<String>? = null,
    public val msiEndpoint: Output<String>? = null,
    public val oidcRequestToken: Output<String>? = null,
    public val oidcRequestUrl: Output<String>? = null,
    public val oidcToken: Output<String>? = null,
    public val partnerId: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val useMsi: Output<Boolean>? = null,
    public val useOidc: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.ProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.ProviderArgs =
        com.pulumi.azurenative.ProviderArgs.builder()
            .auxiliaryTenantIds(auxiliaryTenantIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clientCertificatePassword(clientCertificatePassword?.applyValue({ args0 -> args0 }))
            .clientCertificatePath(clientCertificatePath?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .disablePulumiPartnerId(disablePulumiPartnerId?.applyValue({ args0 -> args0 }))
            .environment(environment?.applyValue({ args0 -> args0 }))
            .msiEndpoint(msiEndpoint?.applyValue({ args0 -> args0 }))
            .oidcRequestToken(oidcRequestToken?.applyValue({ args0 -> args0 }))
            .oidcRequestUrl(oidcRequestUrl?.applyValue({ args0 -> args0 }))
            .oidcToken(oidcToken?.applyValue({ args0 -> args0 }))
            .partnerId(partnerId?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .useMsi(useMsi?.applyValue({ args0 -> args0 }))
            .useOidc(useOidc?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderArgs].
 */
@PulumiTagMarker
public class ProviderArgsBuilder internal constructor() {
    private var auxiliaryTenantIds: Output<List<String>>? = null

    private var clientCertificatePassword: Output<String>? = null

    private var clientCertificatePath: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var disablePulumiPartnerId: Output<Boolean>? = null

    private var environment: Output<String>? = null

    private var msiEndpoint: Output<String>? = null

    private var oidcRequestToken: Output<String>? = null

    private var oidcRequestUrl: Output<String>? = null

    private var oidcToken: Output<String>? = null

    private var partnerId: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var useMsi: Output<Boolean>? = null

    private var useOidc: Output<Boolean>? = null

    /**
     * @param value Any additional Tenant IDs which should be used for authentication.
     */
    @JvmName("ctutgxmblfadpemt")
    public suspend fun auxiliaryTenantIds(`value`: Output<List<String>>) {
        this.auxiliaryTenantIds = value
    }

    @JvmName("rkcixbkaticoprlx")
    public suspend fun auxiliaryTenantIds(vararg values: Output<String>) {
        this.auxiliaryTenantIds = Output.all(values.asList())
    }

    /**
     * @param values Any additional Tenant IDs which should be used for authentication.
     */
    @JvmName("uiselpsshpcnikca")
    public suspend fun auxiliaryTenantIds(values: List<Output<String>>) {
        this.auxiliaryTenantIds = Output.all(values)
    }

    /**
     * @param value The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate
     */
    @JvmName("cnlpjutsstihwvns")
    public suspend fun clientCertificatePassword(`value`: Output<String>) {
        this.clientCertificatePassword = value
    }

    /**
     * @param value The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate.
     */
    @JvmName("ohrufwlrxdoqmixy")
    public suspend fun clientCertificatePath(`value`: Output<String>) {
        this.clientCertificatePath = value
    }

    /**
     * @param value The Client ID which should be used.
     */
    @JvmName("aevxvcxmpwmbrvhp")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
     */
    @JvmName("saorqafumhgonxtw")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value This will disable the Pulumi Partner ID which is used if a custom `partnerId` isn't specified.
     */
    @JvmName("qiqvgrbnilvxaocm")
    public suspend fun disablePulumiPartnerId(`value`: Output<Boolean>) {
        this.disablePulumiPartnerId = value
    }

    /**
     * @param value The Cloud Environment which should be used. Possible values are public, usgovernment, german, and china. Defaults to public.
     */
    @JvmName("etaakjhwodjnsghc")
    public suspend fun environment(`value`: Output<String>) {
        this.environment = value
    }

    /**
     * @param value The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected automatically.
     */
    @JvmName("kjnkgyiaynueeegd")
    public suspend fun msiEndpoint(`value`: Output<String>) {
        this.msiEndpoint = value
    }

    /**
     * @param value Your provider’s token to exchange for an OIDC token.
     */
    @JvmName("kdkeytaeeokgvqxy")
    public suspend fun oidcRequestToken(`value`: Output<String>) {
        this.oidcRequestToken = value
    }

    /**
     * @param value The URL to initiate the `oidcRequestToken` OIDC token exchange.
     */
    @JvmName("msuamsyfotbywlpn")
    public suspend fun oidcRequestUrl(`value`: Output<String>) {
        this.oidcRequestUrl = value
    }

    /**
     * @param value The OIDC token to exchange for an Azure token.
     */
    @JvmName("qskghwxmfhvgcngv")
    public suspend fun oidcToken(`value`: Output<String>) {
        this.oidcToken = value
    }

    /**
     * @param value A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
     */
    @JvmName("qnmehkpicwxudaoj")
    public suspend fun partnerId(`value`: Output<String>) {
        this.partnerId = value
    }

    /**
     * @param value The Subscription ID which should be used.
     */
    @JvmName("fahjyabkjlckvcrk")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The Tenant ID which should be used.
     */
    @JvmName("comlheejagocuepr")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Allow Managed Service Identity to be used for Authentication.
     */
    @JvmName("idipvxkwegoxajfb")
    public suspend fun useMsi(`value`: Output<Boolean>) {
        this.useMsi = value
    }

    /**
     * @param value Allow OpenID Connect (OIDC) to be used for Authentication.
     */
    @JvmName("cjgbbvunjrravgyg")
    public suspend fun useOidc(`value`: Output<Boolean>) {
        this.useOidc = value
    }

    /**
     * @param value Any additional Tenant IDs which should be used for authentication.
     */
    @JvmName("cixffknisevxjnpm")
    public suspend fun auxiliaryTenantIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auxiliaryTenantIds = mapped
    }

    /**
     * @param values Any additional Tenant IDs which should be used for authentication.
     */
    @JvmName("bukvanevhfbngpsf")
    public suspend fun auxiliaryTenantIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auxiliaryTenantIds = mapped
    }

    /**
     * @param value The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate
     */
    @JvmName("cmagfbfbbyoqgela")
    public suspend fun clientCertificatePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificatePassword = mapped
    }

    /**
     * @param value The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate.
     */
    @JvmName("rlhuucumercrpbef")
    public suspend fun clientCertificatePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificatePath = mapped
    }

    /**
     * @param value The Client ID which should be used.
     */
    @JvmName("fdquhdrhbuqoaall")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
     */
    @JvmName("rsbhvqtghdkoetcd")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value This will disable the Pulumi Partner ID which is used if a custom `partnerId` isn't specified.
     */
    @JvmName("qmydgwtytfyihxrv")
    public suspend fun disablePulumiPartnerId(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disablePulumiPartnerId = mapped
    }

    /**
     * @param value The Cloud Environment which should be used. Possible values are public, usgovernment, german, and china. Defaults to public.
     */
    @JvmName("kpimouvjrgrgtlih")
    public suspend fun environment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param value The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected automatically.
     */
    @JvmName("itldjgsuxbiioroy")
    public suspend fun msiEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msiEndpoint = mapped
    }

    /**
     * @param value Your provider’s token to exchange for an OIDC token.
     */
    @JvmName("rjvkykmrqklbgpcb")
    public suspend fun oidcRequestToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcRequestToken = mapped
    }

    /**
     * @param value The URL to initiate the `oidcRequestToken` OIDC token exchange.
     */
    @JvmName("megwiasobweeudac")
    public suspend fun oidcRequestUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcRequestUrl = mapped
    }

    /**
     * @param value The OIDC token to exchange for an Azure token.
     */
    @JvmName("jxoiqgsnovefhkpm")
    public suspend fun oidcToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcToken = mapped
    }

    /**
     * @param value A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
     */
    @JvmName("ikfnhwxnqayvxnqm")
    public suspend fun partnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerId = mapped
    }

    /**
     * @param value The Subscription ID which should be used.
     */
    @JvmName("ndtfxpuqrhpuoqbs")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value The Tenant ID which should be used.
     */
    @JvmName("dkwxpfvtttjvjgxp")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value Allow Managed Service Identity to be used for Authentication.
     */
    @JvmName("bdnifrxgklljlyjp")
    public suspend fun useMsi(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useMsi = mapped
    }

    /**
     * @param value Allow OpenID Connect (OIDC) to be used for Authentication.
     */
    @JvmName("mylxulxhpfusxego")
    public suspend fun useOidc(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useOidc = mapped
    }

    internal fun build(): ProviderArgs = ProviderArgs(
        auxiliaryTenantIds = auxiliaryTenantIds,
        clientCertificatePassword = clientCertificatePassword,
        clientCertificatePath = clientCertificatePath,
        clientId = clientId,
        clientSecret = clientSecret,
        disablePulumiPartnerId = disablePulumiPartnerId,
        environment = environment,
        msiEndpoint = msiEndpoint,
        oidcRequestToken = oidcRequestToken,
        oidcRequestUrl = oidcRequestUrl,
        oidcToken = oidcToken,
        partnerId = partnerId,
        subscriptionId = subscriptionId,
        tenantId = tenantId,
        useMsi = useMsi,
        useOidc = useOidc,
    )
}
