@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetes.kotlin.inputs

import com.pulumi.azurenative.kubernetes.inputs.GetConnectedClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Kubernetes cluster on which get is called.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConnectedClusterPlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetes.inputs.GetConnectedClusterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetes.inputs.GetConnectedClusterPlainArgs =
        com.pulumi.azurenative.kubernetes.inputs.GetConnectedClusterPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectedClusterPlainArgs].
 */
@PulumiTagMarker
public class GetConnectedClusterPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kubernetes cluster on which get is called.
     */
    @JvmName("tjeelcoajuujgnsl")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xsxlfnulvotxuhja")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectedClusterPlainArgs = GetConnectedClusterPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
