@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin

import com.pulumi.azurenative.kubernetesconfiguration.ExtensionArgs.builder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.ExtensionAksAssignedIdentityArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.ExtensionAksAssignedIdentityArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.ExtensionStatusArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.ExtensionStatusArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.PlanArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.ScopeArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.ScopeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Extension object.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * Other available API versions: 2020-07-01-preview, 2022-04-02-preview, 2022-07-01.
 * ## Example Usage
 * ### Create Extension
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.KubernetesConfiguration.Extension("extension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         ConfigurationProtectedSettings =
 *         {
 *             { "omsagent.secret.key", "secretKeyValue01" },
 *         },
 *         ConfigurationSettings =
 *         {
 *             { "omsagent.env.clusterName", "clusterName1" },
 *             { "omsagent.secret.wsid", "a38cef99-5a89-52ed-b6db-22095c23664b" },
 *         },
 *         ExtensionName = "ClusterMonitor",
 *         ExtensionType = "azuremonitor-containers",
 *         ReleaseTrain = "Preview",
 *         ResourceGroupName = "rg1",
 *         Scope = new AzureNative.KubernetesConfiguration.Inputs.ScopeArgs
 *         {
 *             Cluster = new AzureNative.KubernetesConfiguration.Inputs.ScopeClusterArgs
 *             {
 *                 ReleaseNamespace = "kube-system",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewExtension(ctx, "extension", &kubernetesconfiguration.ExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			ClusterName:             pulumi.String("clusterName1"),
 * 			ClusterResourceName:     pulumi.String("connectedClusters"),
 * 			ClusterRp:               pulumi.String("Microsoft.Kubernetes"),
 * 			ConfigurationProtectedSettings: pulumi.StringMap{
 * 				"omsagent.secret.key": pulumi.String("secretKeyValue01"),
 * 			},
 * 			ConfigurationSettings: pulumi.StringMap{
 * 				"omsagent.env.clusterName": pulumi.String("clusterName1"),
 * 				"omsagent.secret.wsid":     pulumi.String("a38cef99-5a89-52ed-b6db-22095c23664b"),
 * 			},
 * 			ExtensionName:     pulumi.String("ClusterMonitor"),
 * 			ExtensionType:     pulumi.String("azuremonitor-containers"),
 * 			ReleaseTrain:      pulumi.String("Preview"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Scope: kubernetesconfiguration.ScopeResponse{
 * 				Cluster: &kubernetesconfiguration.ScopeClusterArgs{
 * 					ReleaseNamespace: pulumi.String("kube-system"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.Extension;
 * import com.pulumi.azurenative.kubernetesconfiguration.ExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .configurationProtectedSettings(Map.of("omsagent.secret.key", "secretKeyValue01"))
 *             .configurationSettings(Map.ofEntries(
 *                 Map.entry("omsagent.env.clusterName", "clusterName1"),
 *                 Map.entry("omsagent.secret.wsid", "a38cef99-5a89-52ed-b6db-22095c23664b")
 *             ))
 *             .extensionName("ClusterMonitor")
 *             .extensionType("azuremonitor-containers")
 *             .releaseTrain("Preview")
 *             .resourceGroupName("rg1")
 *             .scope(Map.of("cluster", Map.of("releaseNamespace", "kube-system")))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Extension with Plan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.KubernetesConfiguration.Extension("extension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         ExtensionName = "azureVote",
 *         ExtensionType = "azure-vote",
 *         Plan = new AzureNative.KubernetesConfiguration.Inputs.PlanArgs
 *         {
 *             Name = "azure-vote-standard",
 *             Product = "azure-vote-standard-offer-id",
 *             Publisher = "Microsoft",
 *         },
 *         ReleaseTrain = "Preview",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewExtension(ctx, "extension", &kubernetesconfiguration.ExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			ClusterName:             pulumi.String("clusterName1"),
 * 			ClusterResourceName:     pulumi.String("connectedClusters"),
 * 			ClusterRp:               pulumi.String("Microsoft.Kubernetes"),
 * 			ExtensionName:           pulumi.String("azureVote"),
 * 			ExtensionType:           pulumi.String("azure-vote"),
 * 			Plan: &kubernetesconfiguration.PlanArgs{
 * 				Name:      pulumi.String("azure-vote-standard"),
 * 				Product:   pulumi.String("azure-vote-standard-offer-id"),
 * 				Publisher: pulumi.String("Microsoft"),
 * 			},
 * 			ReleaseTrain:      pulumi.String("Preview"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.Extension;
 * import com.pulumi.azurenative.kubernetesconfiguration.ExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .extensionName("azureVote")
 *             .extensionType("azure-vote")
 *             .plan(Map.ofEntries(
 *                 Map.entry("name", "azure-vote-standard"),
 *                 Map.entry("product", "azure-vote-standard-offer-id"),
 *                 Map.entry("publisher", "Microsoft")
 *             ))
 *             .releaseTrain("Preview")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesconfiguration:Extension azureVote /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{clusterRp}/{clusterResourceName}/{clusterName}/providers/Microsoft.KubernetesConfiguration/extensions/{extensionName}
 * ```
 * @property aksAssignedIdentity Identity of the Extension resource in an AKS cluster
 * @property autoUpgradeMinorVersion Flag to note if this extension participates in auto upgrade of minor version, or not.
 * @property clusterName The name of the kubernetes cluster.
 * @property clusterResourceName The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
 * @property clusterRp The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
 * @property configurationProtectedSettings Configuration settings that are sensitive, as name-value pairs for configuring this extension.
 * @property configurationSettings Configuration settings, as name-value pairs for configuring this extension.
 * @property extensionName Name of the Extension.
 * @property extensionType Type of the Extension, of which this resource is an instance of.  It must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the Extension publisher.
 * @property identity Identity of the Extension resource
 * @property plan The plan information.
 * @property releaseTrain ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope Scope at which the extension is installed.
 * @property statuses Status from this extension.
 * @property version User-specified version of the extension for this extension to 'pin'. To use 'version', autoUpgradeMinorVersion must be 'false'.
 */
public data class ExtensionArgs(
    public val aksAssignedIdentity: Output<ExtensionAksAssignedIdentityArgs>? = null,
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val clusterName: Output<String>? = null,
    public val clusterResourceName: Output<String>? = null,
    public val clusterRp: Output<String>? = null,
    public val configurationProtectedSettings: Output<Map<String, String>>? = null,
    public val configurationSettings: Output<Map<String, String>>? = null,
    public val extensionName: Output<String>? = null,
    public val extensionType: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val plan: Output<PlanArgs>? = null,
    public val releaseTrain: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<ScopeArgs>? = null,
    public val statuses: Output<List<ExtensionStatusArgs>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.ExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.ExtensionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.ExtensionArgs.builder()
            .aksAssignedIdentity(
                aksAssignedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterResourceName(clusterResourceName?.applyValue({ args0 -> args0 }))
            .clusterRp(clusterRp?.applyValue({ args0 -> args0 }))
            .configurationProtectedSettings(
                configurationProtectedSettings?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .configurationSettings(
                configurationSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .extensionName(extensionName?.applyValue({ args0 -> args0 }))
            .extensionType(extensionType?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .releaseTrain(releaseTrain?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .statuses(
                statuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionArgs].
 */
@PulumiTagMarker
public class ExtensionArgsBuilder internal constructor() {
    private var aksAssignedIdentity: Output<ExtensionAksAssignedIdentityArgs>? = null

    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var clusterName: Output<String>? = null

    private var clusterResourceName: Output<String>? = null

    private var clusterRp: Output<String>? = null

    private var configurationProtectedSettings: Output<Map<String, String>>? = null

    private var configurationSettings: Output<Map<String, String>>? = null

    private var extensionName: Output<String>? = null

    private var extensionType: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var plan: Output<PlanArgs>? = null

    private var releaseTrain: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<ScopeArgs>? = null

    private var statuses: Output<List<ExtensionStatusArgs>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Identity of the Extension resource in an AKS cluster
     */
    @JvmName("uqmaejmbbefcnuho")
    public suspend fun aksAssignedIdentity(`value`: Output<ExtensionAksAssignedIdentityArgs>) {
        this.aksAssignedIdentity = value
    }

    /**
     * @param value Flag to note if this extension participates in auto upgrade of minor version, or not.
     */
    @JvmName("mxajpvpkbytgmpnn")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value The name of the kubernetes cluster.
     */
    @JvmName("uffllbjdmrudqjel")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     */
    @JvmName("ebcacnbscnopnion")
    public suspend fun clusterResourceName(`value`: Output<String>) {
        this.clusterResourceName = value
    }

    /**
     * @param value The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     */
    @JvmName("bulorgiksoobbgqa")
    public suspend fun clusterRp(`value`: Output<String>) {
        this.clusterRp = value
    }

    /**
     * @param value Configuration settings that are sensitive, as name-value pairs for configuring this extension.
     */
    @JvmName("wabihekrvhgauppp")
    public suspend fun configurationProtectedSettings(`value`: Output<Map<String, String>>) {
        this.configurationProtectedSettings = value
    }

    /**
     * @param value Configuration settings, as name-value pairs for configuring this extension.
     */
    @JvmName("kspkkvhrvqinkxer")
    public suspend fun configurationSettings(`value`: Output<Map<String, String>>) {
        this.configurationSettings = value
    }

    /**
     * @param value Name of the Extension.
     */
    @JvmName("hxhxxwfkhbldffqi")
    public suspend fun extensionName(`value`: Output<String>) {
        this.extensionName = value
    }

    /**
     * @param value Type of the Extension, of which this resource is an instance of.  It must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the Extension publisher.
     */
    @JvmName("yxaxlorhqpwvujhy")
    public suspend fun extensionType(`value`: Output<String>) {
        this.extensionType = value
    }

    /**
     * @param value Identity of the Extension resource
     */
    @JvmName("nbdmynrhbmvltpca")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The plan information.
     */
    @JvmName("qmanpilvsalwnmlm")
    public suspend fun plan(`value`: Output<PlanArgs>) {
        this.plan = value
    }

    /**
     * @param value ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
     */
    @JvmName("ankrcwmkpicjdhlm")
    public suspend fun releaseTrain(`value`: Output<String>) {
        this.releaseTrain = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qvmpjksgdkojlsxd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Scope at which the extension is installed.
     */
    @JvmName("lubobiwpgbmcbofw")
    public suspend fun scope(`value`: Output<ScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value Status from this extension.
     */
    @JvmName("kqlrsulbdfhydijd")
    public suspend fun statuses(`value`: Output<List<ExtensionStatusArgs>>) {
        this.statuses = value
    }

    @JvmName("tspnakjteucatvch")
    public suspend fun statuses(vararg values: Output<ExtensionStatusArgs>) {
        this.statuses = Output.all(values.asList())
    }

    /**
     * @param values Status from this extension.
     */
    @JvmName("vrayydbdnanhsotf")
    public suspend fun statuses(values: List<Output<ExtensionStatusArgs>>) {
        this.statuses = Output.all(values)
    }

    /**
     * @param value User-specified version of the extension for this extension to 'pin'. To use 'version', autoUpgradeMinorVersion must be 'false'.
     */
    @JvmName("thcxknvugkpbrbrg")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Identity of the Extension resource in an AKS cluster
     */
    @JvmName("mybmjybflvatxnxr")
    public suspend fun aksAssignedIdentity(`value`: ExtensionAksAssignedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aksAssignedIdentity = mapped
    }

    /**
     * @param argument Identity of the Extension resource in an AKS cluster
     */
    @JvmName("qfqqqnavicdxedis")
    public suspend
    fun aksAssignedIdentity(argument: suspend ExtensionAksAssignedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ExtensionAksAssignedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aksAssignedIdentity = mapped
    }

    /**
     * @param value Flag to note if this extension participates in auto upgrade of minor version, or not.
     */
    @JvmName("ffdfavsoscpfrxjt")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value The name of the kubernetes cluster.
     */
    @JvmName("huuqrxsvjokebxjm")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     */
    @JvmName("bbxoxtswvxfpgqnj")
    public suspend fun clusterResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterResourceName = mapped
    }

    /**
     * @param value The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     */
    @JvmName("whonixqtvbggilfb")
    public suspend fun clusterRp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterRp = mapped
    }

    /**
     * @param value Configuration settings that are sensitive, as name-value pairs for configuring this extension.
     */
    @JvmName("xwvnuurpgdtyluoh")
    public suspend fun configurationProtectedSettings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProtectedSettings = mapped
    }

    /**
     * @param values Configuration settings that are sensitive, as name-value pairs for configuring this extension.
     */
    @JvmName("hfxyxyovuivcplns")
    public fun configurationProtectedSettings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationProtectedSettings = mapped
    }

    /**
     * @param value Configuration settings, as name-value pairs for configuring this extension.
     */
    @JvmName("fdlhjfknantiietr")
    public suspend fun configurationSettings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationSettings = mapped
    }

    /**
     * @param values Configuration settings, as name-value pairs for configuring this extension.
     */
    @JvmName("syfcpulhnxcetvnc")
    public fun configurationSettings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationSettings = mapped
    }

    /**
     * @param value Name of the Extension.
     */
    @JvmName("ixcsuswycukdwfix")
    public suspend fun extensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionName = mapped
    }

    /**
     * @param value Type of the Extension, of which this resource is an instance of.  It must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the Extension publisher.
     */
    @JvmName("neiaolsmclauxgvg")
    public suspend fun extensionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionType = mapped
    }

    /**
     * @param value Identity of the Extension resource
     */
    @JvmName("xwsnrccbwnyiigxt")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity of the Extension resource
     */
    @JvmName("aecgxqayajeotpbf")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The plan information.
     */
    @JvmName("xbthehsklqaeiqmy")
    public suspend fun plan(`value`: PlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument The plan information.
     */
    @JvmName("hpgmodvxfpujccsk")
    public suspend fun plan(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
     */
    @JvmName("klctffanjulhhyis")
    public suspend fun releaseTrain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseTrain = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ehqahgcrwboehfav")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Scope at which the extension is installed.
     */
    @JvmName("rfotswcbwodjcgiq")
    public suspend fun scope(`value`: ScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument Scope at which the extension is installed.
     */
    @JvmName("xkcnkjqgvnbxjqvk")
    public suspend fun scope(argument: suspend ScopeArgsBuilder.() -> Unit) {
        val toBeMapped = ScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value Status from this extension.
     */
    @JvmName("iluknicgslugbdky")
    public suspend fun statuses(`value`: List<ExtensionStatusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statuses = mapped
    }

    /**
     * @param argument Status from this extension.
     */
    @JvmName("lojgmqgttlstpkml")
    public suspend fun statuses(argument: List<suspend ExtensionStatusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtensionStatusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statuses = mapped
    }

    /**
     * @param argument Status from this extension.
     */
    @JvmName("rlnkidxfushpiqiu")
    public suspend fun statuses(vararg argument: suspend ExtensionStatusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExtensionStatusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statuses = mapped
    }

    /**
     * @param argument Status from this extension.
     */
    @JvmName("qmsyeioyyeoxvkks")
    public suspend fun statuses(argument: suspend ExtensionStatusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExtensionStatusArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.statuses = mapped
    }

    /**
     * @param values Status from this extension.
     */
    @JvmName("epaqerppbkercwtw")
    public suspend fun statuses(vararg values: ExtensionStatusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statuses = mapped
    }

    /**
     * @param value User-specified version of the extension for this extension to 'pin'. To use 'version', autoUpgradeMinorVersion must be 'false'.
     */
    @JvmName("tkgbjnxvqkdyoasc")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ExtensionArgs = ExtensionArgs(
        aksAssignedIdentity = aksAssignedIdentity,
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        clusterName = clusterName,
        clusterResourceName = clusterResourceName,
        clusterRp = clusterRp,
        configurationProtectedSettings = configurationProtectedSettings,
        configurationSettings = configurationSettings,
        extensionName = extensionName,
        extensionType = extensionType,
        identity = identity,
        plan = plan,
        releaseTrain = releaseTrain,
        resourceGroupName = resourceGroupName,
        scope = scope,
        statuses = statuses,
        version = version,
    )
}
