@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin

import com.pulumi.azurenative.kubernetesconfiguration.FluxConfigurationArgs.builder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.enums.ScopeType
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.enums.SourceKindType
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.AzureBlobDefinitionArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.AzureBlobDefinitionArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.BucketDefinitionArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.BucketDefinitionArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GitRepositoryDefinitionArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.GitRepositoryDefinitionArgsBuilder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.KustomizationDefinitionArgs
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs.KustomizationDefinitionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Flux Configuration object returned in Get & Put response.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * Other available API versions: 2021-11-01-preview, 2022-01-01-preview.
 * ## Example Usage
 * ### Create Flux Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fluxConfiguration = new AzureNative.KubernetesConfiguration.FluxConfiguration("fluxConfiguration", new()
 *     {
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         FluxConfigurationName = "srs-fluxconfig",
 *         GitRepository = new AzureNative.KubernetesConfiguration.Inputs.GitRepositoryDefinitionArgs
 *         {
 *             HttpsCACert = "ZXhhbXBsZWNlcnRpZmljYXRl",
 *             RepositoryRef = new AzureNative.KubernetesConfiguration.Inputs.RepositoryRefDefinitionArgs
 *             {
 *                 Branch = "master",
 *             },
 *             SyncIntervalInSeconds = 600,
 *             TimeoutInSeconds = 600,
 *             Url = "https://github.com/Azure/arc-k8s-demo",
 *         },
 *         Kustomizations =
 *         {
 *             { "srs-kustomization1", new AzureNative.KubernetesConfiguration.Inputs.KustomizationDefinitionArgs
 *             {
 *                 DependsOn = new() { },
 *                 Path = "./test/path",
 *                 PostBuild = new AzureNative.KubernetesConfiguration.Inputs.PostBuildDefinitionArgs
 *                 {
 *                     Substitute =
 *                     {
 *                         { "cluster_env", "prod" },
 *                         { "replica_count", "2" },
 *                     },
 *                     SubstituteFrom = new[]
 *                     {
 *                         new AzureNative.KubernetesConfiguration.Inputs.SubstituteFromDefinitionArgs
 *                         {
 *                             Kind = "ConfigMap",
 *                             Name = "cluster-test",
 *                             Optional = true,
 *                         },
 *                     },
 *                 },
 *                 SyncIntervalInSeconds = 600,
 *                 TimeoutInSeconds = 600,
 *                 Wait = true,
 *             } },
 *             { "srs-kustomization2", new AzureNative.KubernetesConfiguration.Inputs.KustomizationDefinitionArgs
 *             {
 *                 DependsOn = new[]
 *                 {
 *                     "srs-kustomization1",
 *                 },
 *                 Path = "./other/test/path",
 *                 PostBuild = new AzureNative.KubernetesConfiguration.Inputs.PostBuildDefinitionArgs
 *                 {
 *                     SubstituteFrom = new[]
 *                     {
 *                         new AzureNative.KubernetesConfiguration.Inputs.SubstituteFromDefinitionArgs
 *                         {
 *                             Kind = "ConfigMap",
 *                             Name = "cluster-values",
 *                             Optional = true,
 *                         },
 *                         new AzureNative.KubernetesConfiguration.Inputs.SubstituteFromDefinitionArgs
 *                         {
 *                             Kind = "Secret",
 *                             Name = "secret-name",
 *                             Optional = false,
 *                         },
 *                     },
 *                 },
 *                 Prune = false,
 *                 RetryIntervalInSeconds = 600,
 *                 SyncIntervalInSeconds = 600,
 *                 TimeoutInSeconds = 600,
 *                 Wait = false,
 *             } },
 *         },
 *         Namespace = "srs-namespace",
 *         ReconciliationWaitDuration = "PT30M",
 *         ResourceGroupName = "rg1",
 *         Scope = "cluster",
 *         SourceKind = "GitRepository",
 *         Suspend = false,
 *         WaitForReconciliation = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewFluxConfiguration(ctx, "fluxConfiguration", &kubernetesconfiguration.FluxConfigurationArgs{
 * 			ClusterName:           pulumi.String("clusterName1"),
 * 			ClusterResourceName:   pulumi.String("connectedClusters"),
 * 			ClusterRp:             pulumi.String("Microsoft.Kubernetes"),
 * 			FluxConfigurationName: pulumi.String("srs-fluxconfig"),
 * 			GitRepository: kubernetesconfiguration.GitRepositoryDefinitionResponse{
 * 				HttpsCACert: pulumi.String("ZXhhbXBsZWNlcnRpZmljYXRl"),
 * 				RepositoryRef: &kubernetesconfiguration.RepositoryRefDefinitionArgs{
 * 					Branch: pulumi.String("master"),
 * 				},
 * 				SyncIntervalInSeconds: pulumi.Float64(600),
 * 				TimeoutInSeconds:      pulumi.Float64(600),
 * 				Url:                   pulumi.String("https://github.com/Azure/arc-k8s-demo"),
 * 			},
 * 			Kustomizations: kubernetesconfiguration.KustomizationDefinitionMap{
 * 				"srs-kustomization1": &kubernetesconfiguration.KustomizationDefinitionArgs{
 * 					DependsOn: pulumi.StringArray{},
 * 					Path:      pulumi.String("./test/path"),
 * 					PostBuild: &kubernetesconfiguration.PostBuildDefinitionArgs{
 * 						Substitute: pulumi.StringMap{
 * 							"cluster_env":   pulumi.String("prod"),
 * 							"replica_count": pulumi.String("2"),
 * 						},
 * 						SubstituteFrom: kubernetesconfiguration.SubstituteFromDefinitionArray{
 * 							&kubernetesconfiguration.SubstituteFromDefinitionArgs{
 * 								Kind:     pulumi.String("ConfigMap"),
 * 								Name:     pulumi.String("cluster-test"),
 * 								Optional: pulumi.Bool(true),
 * 							},
 * 						},
 * 					},
 * 					SyncIntervalInSeconds: pulumi.Float64(600),
 * 					TimeoutInSeconds:      pulumi.Float64(600),
 * 					Wait:                  pulumi.Bool(true),
 * 				},
 * 				"srs-kustomization2": &kubernetesconfiguration.KustomizationDefinitionArgs{
 * 					DependsOn: pulumi.StringArray{
 * 						pulumi.String("srs-kustomization1"),
 * 					},
 * 					Path: pulumi.String("./other/test/path"),
 * 					PostBuild: &kubernetesconfiguration.PostBuildDefinitionArgs{
 * 						SubstituteFrom: kubernetesconfiguration.SubstituteFromDefinitionArray{
 * 							&kubernetesconfiguration.SubstituteFromDefinitionArgs{
 * 								Kind:     pulumi.String("ConfigMap"),
 * 								Name:     pulumi.String("cluster-values"),
 * 								Optional: pulumi.Bool(true),
 * 							},
 * 							&kubernetesconfiguration.SubstituteFromDefinitionArgs{
 * 								Kind:     pulumi.String("Secret"),
 * 								Name:     pulumi.String("secret-name"),
 * 								Optional: pulumi.Bool(false),
 * 							},
 * 						},
 * 					},
 * 					Prune:                  pulumi.Bool(false),
 * 					RetryIntervalInSeconds: pulumi.Float64(600),
 * 					SyncIntervalInSeconds:  pulumi.Float64(600),
 * 					TimeoutInSeconds:       pulumi.Float64(600),
 * 					Wait:                   pulumi.Bool(false),
 * 				},
 * 			},
 * 			Namespace:                  pulumi.String("srs-namespace"),
 * 			ReconciliationWaitDuration: pulumi.String("PT30M"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			Scope:                      pulumi.String("cluster"),
 * 			SourceKind:                 pulumi.String("GitRepository"),
 * 			Suspend:                    pulumi.Bool(false),
 * 			WaitForReconciliation:      pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.FluxConfiguration;
 * import com.pulumi.azurenative.kubernetesconfiguration.FluxConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fluxConfiguration = new FluxConfiguration("fluxConfiguration", FluxConfigurationArgs.builder()
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .fluxConfigurationName("srs-fluxconfig")
 *             .gitRepository(Map.ofEntries(
 *                 Map.entry("httpsCACert", "ZXhhbXBsZWNlcnRpZmljYXRl"),
 *                 Map.entry("repositoryRef", Map.of("branch", "master")),
 *                 Map.entry("syncIntervalInSeconds", 600),
 *                 Map.entry("timeoutInSeconds", 600),
 *                 Map.entry("url", "https://github.com/Azure/arc-k8s-demo")
 *             ))
 *             .kustomizations(Map.ofEntries(
 *                 Map.entry("srs-kustomization1", Map.ofEntries(
 *                     Map.entry("dependsOn", ),
 *                     Map.entry("path", "./test/path"),
 *                     Map.entry("postBuild", Map.ofEntries(
 *                         Map.entry("substitute", Map.ofEntries(
 *                             Map.entry("cluster_env", "prod"),
 *                             Map.entry("replica_count", "2")
 *                         )),
 *                         Map.entry("substituteFrom", Map.ofEntries(
 *                             Map.entry("kind", "ConfigMap"),
 *                             Map.entry("name", "cluster-test"),
 *                             Map.entry("optional", true)
 *                         ))
 *                     )),
 *                     Map.entry("syncIntervalInSeconds", 600),
 *                     Map.entry("timeoutInSeconds", 600),
 *                     Map.entry("wait", true)
 *                 )),
 *                 Map.entry("srs-kustomization2", Map.ofEntries(
 *                     Map.entry("dependsOn", "srs-kustomization1"),
 *                     Map.entry("path", "./other/test/path"),
 *                     Map.entry("postBuild", Map.of("substituteFrom",
 *                         Map.ofEntries(
 *                             Map.entry("kind", "ConfigMap"),
 *                             Map.entry("name", "cluster-values"),
 *                             Map.entry("optional", true)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("kind", "Secret"),
 *                             Map.entry("name", "secret-name"),
 *                             Map.entry("optional", false)
 *                         ))),
 *                     Map.entry("prune", false),
 *                     Map.entry("retryIntervalInSeconds", 600),
 *                     Map.entry("syncIntervalInSeconds", 600),
 *                     Map.entry("timeoutInSeconds", 600),
 *                     Map.entry("wait", false)
 *                 ))
 *             ))
 *             .namespace("srs-namespace")
 *             .reconciliationWaitDuration("PT30M")
 *             .resourceGroupName("rg1")
 *             .scope("cluster")
 *             .sourceKind("GitRepository")
 *             .suspend(false)
 *             .waitForReconciliation(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Create Flux Configuration with Bucket Source Kind
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fluxConfiguration = new AzureNative.KubernetesConfiguration.FluxConfiguration("fluxConfiguration", new()
 *     {
 *         Bucket = new AzureNative.KubernetesConfiguration.Inputs.BucketDefinitionArgs
 *         {
 *             AccessKey = "fluxminiotest",
 *             BucketName = "flux",
 *             SyncIntervalInSeconds = 1000,
 *             TimeoutInSeconds = 1000,
 *             Url = "https://fluxminiotest.az.minio.io",
 *         },
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         FluxConfigurationName = "srs-fluxconfig",
 *         Kustomizations =
 *         {
 *             { "srs-kustomization1", new AzureNative.KubernetesConfiguration.Inputs.KustomizationDefinitionArgs
 *             {
 *                 DependsOn = new() { },
 *                 Path = "./test/path",
 *                 SyncIntervalInSeconds = 600,
 *                 TimeoutInSeconds = 600,
 *             } },
 *             { "srs-kustomization2", new AzureNative.KubernetesConfiguration.Inputs.KustomizationDefinitionArgs
 *             {
 *                 DependsOn = new[]
 *                 {
 *                     "srs-kustomization1",
 *                 },
 *                 Path = "./other/test/path",
 *                 Prune = false,
 *                 RetryIntervalInSeconds = 600,
 *                 SyncIntervalInSeconds = 600,
 *                 TimeoutInSeconds = 600,
 *             } },
 *         },
 *         Namespace = "srs-namespace",
 *         ResourceGroupName = "rg1",
 *         Scope = "cluster",
 *         SourceKind = "Bucket",
 *         Suspend = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewFluxConfiguration(ctx, "fluxConfiguration", &kubernetesconfiguration.FluxConfigurationArgs{
 * 			Bucket: &kubernetesconfiguration.BucketDefinitionArgs{
 * 				AccessKey:             pulumi.String("fluxminiotest"),
 * 				BucketName:            pulumi.String("flux"),
 * 				SyncIntervalInSeconds: pulumi.Float64(1000),
 * 				TimeoutInSeconds:      pulumi.Float64(1000),
 * 				Url:                   pulumi.String("https://fluxminiotest.az.minio.io"),
 * 			},
 * 			ClusterName:           pulumi.String("clusterName1"),
 * 			ClusterResourceName:   pulumi.String("connectedClusters"),
 * 			ClusterRp:             pulumi.String("Microsoft.Kubernetes"),
 * 			FluxConfigurationName: pulumi.String("srs-fluxconfig"),
 * 			Kustomizations: kubernetesconfiguration.KustomizationDefinitionMap{
 * 				"srs-kustomization1": &kubernetesconfiguration.KustomizationDefinitionArgs{
 * 					DependsOn:             pulumi.StringArray{},
 * 					Path:                  pulumi.String("./test/path"),
 * 					SyncIntervalInSeconds: pulumi.Float64(600),
 * 					TimeoutInSeconds:      pulumi.Float64(600),
 * 				},
 * 				"srs-kustomization2": &kubernetesconfiguration.KustomizationDefinitionArgs{
 * 					DependsOn: pulumi.StringArray{
 * 						pulumi.String("srs-kustomization1"),
 * 					},
 * 					Path:                   pulumi.String("./other/test/path"),
 * 					Prune:                  pulumi.Bool(false),
 * 					RetryIntervalInSeconds: pulumi.Float64(600),
 * 					SyncIntervalInSeconds:  pulumi.Float64(600),
 * 					TimeoutInSeconds:       pulumi.Float64(600),
 * 				},
 * 			},
 * 			Namespace:         pulumi.String("srs-namespace"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Scope:             pulumi.String("cluster"),
 * 			SourceKind:        pulumi.String("Bucket"),
 * 			Suspend:           pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.FluxConfiguration;
 * import com.pulumi.azurenative.kubernetesconfiguration.FluxConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fluxConfiguration = new FluxConfiguration("fluxConfiguration", FluxConfigurationArgs.builder()
 *             .bucket(Map.ofEntries(
 *                 Map.entry("accessKey", "fluxminiotest"),
 *                 Map.entry("bucketName", "flux"),
 *                 Map.entry("syncIntervalInSeconds", 1000),
 *                 Map.entry("timeoutInSeconds", 1000),
 *                 Map.entry("url", "https://fluxminiotest.az.minio.io")
 *             ))
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .fluxConfigurationName("srs-fluxconfig")
 *             .kustomizations(Map.ofEntries(
 *                 Map.entry("srs-kustomization1", Map.ofEntries(
 *                     Map.entry("dependsOn", ),
 *                     Map.entry("path", "./test/path"),
 *                     Map.entry("syncIntervalInSeconds", 600),
 *                     Map.entry("timeoutInSeconds", 600)
 *                 )),
 *                 Map.entry("srs-kustomization2", Map.ofEntries(
 *                     Map.entry("dependsOn", "srs-kustomization1"),
 *                     Map.entry("path", "./other/test/path"),
 *                     Map.entry("prune", false),
 *                     Map.entry("retryIntervalInSeconds", 600),
 *                     Map.entry("syncIntervalInSeconds", 600),
 *                     Map.entry("timeoutInSeconds", 600)
 *                 ))
 *             ))
 *             .namespace("srs-namespace")
 *             .resourceGroupName("rg1")
 *             .scope("cluster")
 *             .sourceKind("Bucket")
 *             .suspend(false)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesconfiguration:FluxConfiguration srs-fluxconfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{clusterRp}/{clusterResourceName}/{clusterName}/providers/Microsoft.KubernetesConfiguration/fluxConfigurations/{fluxConfigurationName}
 * ```
 * @property azureBlob Parameters to reconcile to the AzureBlob source kind type.
 * @property bucket Parameters to reconcile to the Bucket source kind type.
 * @property clusterName The name of the kubernetes cluster.
 * @property clusterResourceName The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
 * @property clusterRp The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
 * @property configurationProtectedSettings Key-value pairs of protected configuration settings for the configuration
 * @property fluxConfigurationName Name of the Flux Configuration.
 * @property gitRepository Parameters to reconcile to the GitRepository source kind type.
 * @property kustomizations Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
 * @property namespace The namespace to which this configuration is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
 * @property reconciliationWaitDuration Maximum duration to wait for flux configuration reconciliation. E.g PT1H, PT5M, P1D
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope Scope at which the operator will be installed.
 * @property sourceKind Source Kind to pull the configuration data from.
 * @property suspend Whether this configuration should suspend its reconciliation of its kustomizations and sources.
 * @property waitForReconciliation Whether flux configuration deployment should wait for cluster to reconcile the kustomizations.
 */
public data class FluxConfigurationArgs(
    public val azureBlob: Output<AzureBlobDefinitionArgs>? = null,
    public val bucket: Output<BucketDefinitionArgs>? = null,
    public val clusterName: Output<String>? = null,
    public val clusterResourceName: Output<String>? = null,
    public val clusterRp: Output<String>? = null,
    public val configurationProtectedSettings: Output<Map<String, String>>? = null,
    public val fluxConfigurationName: Output<String>? = null,
    public val gitRepository: Output<GitRepositoryDefinitionArgs>? = null,
    public val kustomizations: Output<Map<String, KustomizationDefinitionArgs>>? = null,
    public val namespace: Output<String>? = null,
    public val reconciliationWaitDuration: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<Either<String, ScopeType>>? = null,
    public val sourceKind: Output<Either<String, SourceKindType>>? = null,
    public val `suspend`: Output<Boolean>? = null,
    public val waitForReconciliation: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.FluxConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.FluxConfigurationArgs =
        com.pulumi.azurenative.kubernetesconfiguration.FluxConfigurationArgs.builder()
            .azureBlob(azureBlob?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .bucket(bucket?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterResourceName(clusterResourceName?.applyValue({ args0 -> args0 }))
            .clusterRp(clusterRp?.applyValue({ args0 -> args0 }))
            .configurationProtectedSettings(
                configurationProtectedSettings?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .fluxConfigurationName(fluxConfigurationName?.applyValue({ args0 -> args0 }))
            .gitRepository(gitRepository?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kustomizations(
                kustomizations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .reconciliationWaitDuration(reconciliationWaitDuration?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(
                scope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceKind(
                sourceKind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`suspend`(`suspend`?.applyValue({ args0 -> args0 }))
            .waitForReconciliation(waitForReconciliation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FluxConfigurationArgs].
 */
@PulumiTagMarker
public class FluxConfigurationArgsBuilder internal constructor() {
    private var azureBlob: Output<AzureBlobDefinitionArgs>? = null

    private var bucket: Output<BucketDefinitionArgs>? = null

    private var clusterName: Output<String>? = null

    private var clusterResourceName: Output<String>? = null

    private var clusterRp: Output<String>? = null

    private var configurationProtectedSettings: Output<Map<String, String>>? = null

    private var fluxConfigurationName: Output<String>? = null

    private var gitRepository: Output<GitRepositoryDefinitionArgs>? = null

    private var kustomizations: Output<Map<String, KustomizationDefinitionArgs>>? = null

    private var namespace: Output<String>? = null

    private var reconciliationWaitDuration: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<Either<String, ScopeType>>? = null

    private var sourceKind: Output<Either<String, SourceKindType>>? = null

    private var `suspend`: Output<Boolean>? = null

    private var waitForReconciliation: Output<Boolean>? = null

    /**
     * @param value Parameters to reconcile to the AzureBlob source kind type.
     */
    @JvmName("brbglwbqcshjknvj")
    public suspend fun azureBlob(`value`: Output<AzureBlobDefinitionArgs>) {
        this.azureBlob = value
    }

    /**
     * @param value Parameters to reconcile to the Bucket source kind type.
     */
    @JvmName("tgqjresoklcsicwm")
    public suspend fun bucket(`value`: Output<BucketDefinitionArgs>) {
        this.bucket = value
    }

    /**
     * @param value The name of the kubernetes cluster.
     */
    @JvmName("tuddjbwmjyuchlih")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     */
    @JvmName("mpaynqdmfpscdpqy")
    public suspend fun clusterResourceName(`value`: Output<String>) {
        this.clusterResourceName = value
    }

    /**
     * @param value The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     */
    @JvmName("aobtcomtlsqojses")
    public suspend fun clusterRp(`value`: Output<String>) {
        this.clusterRp = value
    }

    /**
     * @param value Key-value pairs of protected configuration settings for the configuration
     */
    @JvmName("suohcrauaivfnofc")
    public suspend fun configurationProtectedSettings(`value`: Output<Map<String, String>>) {
        this.configurationProtectedSettings = value
    }

    /**
     * @param value Name of the Flux Configuration.
     */
    @JvmName("sfkqjmjsremgggnl")
    public suspend fun fluxConfigurationName(`value`: Output<String>) {
        this.fluxConfigurationName = value
    }

    /**
     * @param value Parameters to reconcile to the GitRepository source kind type.
     */
    @JvmName("gwflpeveecwlhhfs")
    public suspend fun gitRepository(`value`: Output<GitRepositoryDefinitionArgs>) {
        this.gitRepository = value
    }

    /**
     * @param value Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
     */
    @JvmName("nacjmdpgpdpwkdey")
    public suspend fun kustomizations(`value`: Output<Map<String, KustomizationDefinitionArgs>>) {
        this.kustomizations = value
    }

    /**
     * @param value The namespace to which this configuration is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
     */
    @JvmName("tptwwunemqqpftaw")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Maximum duration to wait for flux configuration reconciliation. E.g PT1H, PT5M, P1D
     */
    @JvmName("gkkmphfikuapwkwb")
    public suspend fun reconciliationWaitDuration(`value`: Output<String>) {
        this.reconciliationWaitDuration = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ttovdutoaslxcitw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Scope at which the operator will be installed.
     */
    @JvmName("xkpikuxtqccyssse")
    public suspend fun scope(`value`: Output<Either<String, ScopeType>>) {
        this.scope = value
    }

    /**
     * @param value Source Kind to pull the configuration data from.
     */
    @JvmName("itsvdrrmjfrbufgc")
    public suspend fun sourceKind(`value`: Output<Either<String, SourceKindType>>) {
        this.sourceKind = value
    }

    /**
     * @param value Whether this configuration should suspend its reconciliation of its kustomizations and sources.
     */
    @JvmName("obynyxtumxmaddpw")
    public suspend fun `suspend`(`value`: Output<Boolean>) {
        this.`suspend` = value
    }

    /**
     * @param value Whether flux configuration deployment should wait for cluster to reconcile the kustomizations.
     */
    @JvmName("xertnvtxxlehfpap")
    public suspend fun waitForReconciliation(`value`: Output<Boolean>) {
        this.waitForReconciliation = value
    }

    /**
     * @param value Parameters to reconcile to the AzureBlob source kind type.
     */
    @JvmName("hdplwwisvewmjrem")
    public suspend fun azureBlob(`value`: AzureBlobDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureBlob = mapped
    }

    /**
     * @param argument Parameters to reconcile to the AzureBlob source kind type.
     */
    @JvmName("gjaaajoxcfoosxth")
    public suspend fun azureBlob(argument: suspend AzureBlobDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = AzureBlobDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureBlob = mapped
    }

    /**
     * @param value Parameters to reconcile to the Bucket source kind type.
     */
    @JvmName("wprwhptiacqrlxsb")
    public suspend fun bucket(`value`: BucketDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param argument Parameters to reconcile to the Bucket source kind type.
     */
    @JvmName("fnenfofsbpqosyka")
    public suspend fun bucket(argument: suspend BucketDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = BucketDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bucket = mapped
    }

    /**
     * @param value The name of the kubernetes cluster.
     */
    @JvmName("uyxosovqhutxxhyt")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     */
    @JvmName("jmhsghtanbfftbkp")
    public suspend fun clusterResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterResourceName = mapped
    }

    /**
     * @param value The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     */
    @JvmName("jlpmwmnnbbrlrofi")
    public suspend fun clusterRp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterRp = mapped
    }

    /**
     * @param value Key-value pairs of protected configuration settings for the configuration
     */
    @JvmName("xptpwpugjoakorsj")
    public suspend fun configurationProtectedSettings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProtectedSettings = mapped
    }

    /**
     * @param values Key-value pairs of protected configuration settings for the configuration
     */
    @JvmName("bjjfywddpexdpcto")
    public fun configurationProtectedSettings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationProtectedSettings = mapped
    }

    /**
     * @param value Name of the Flux Configuration.
     */
    @JvmName("jclwhauleywnkhvd")
    public suspend fun fluxConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fluxConfigurationName = mapped
    }

    /**
     * @param value Parameters to reconcile to the GitRepository source kind type.
     */
    @JvmName("xckdgjqjnhjhrlcm")
    public suspend fun gitRepository(`value`: GitRepositoryDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitRepository = mapped
    }

    /**
     * @param argument Parameters to reconcile to the GitRepository source kind type.
     */
    @JvmName("gjnwhadnklvjoquv")
    public suspend
    fun gitRepository(argument: suspend GitRepositoryDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = GitRepositoryDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitRepository = mapped
    }

    /**
     * @param value Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
     */
    @JvmName("xeasepebutwnlimg")
    public suspend fun kustomizations(`value`: Map<String, KustomizationDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustomizations = mapped
    }

    /**
     * @param argument Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
     */
    @JvmName("vrigemettusmtpai")
    public suspend fun kustomizations(
        vararg
        argument: Pair<String, suspend KustomizationDefinitionArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                KustomizationDefinitionArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.kustomizations = mapped
    }

    /**
     * @param values Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
     */
    @JvmName("ydujcfkadvesyejb")
    public fun kustomizations(vararg values: Pair<String, KustomizationDefinitionArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kustomizations = mapped
    }

    /**
     * @param value The namespace to which this configuration is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
     */
    @JvmName("bspmuwykiiidlsve")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Maximum duration to wait for flux configuration reconciliation. E.g PT1H, PT5M, P1D
     */
    @JvmName("vrjwbormqtbcgkdt")
    public suspend fun reconciliationWaitDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reconciliationWaitDuration = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uemkkpaqkgcixmuv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Scope at which the operator will be installed.
     */
    @JvmName("txyufwwxwmwhoytt")
    public suspend fun scope(`value`: Either<String, ScopeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Scope at which the operator will be installed.
     */
    @JvmName("klnlkskasatrjhry")
    public fun scope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Scope at which the operator will be installed.
     */
    @JvmName("ragrfvrvohvrxeeo")
    public fun scope(`value`: ScopeType) {
        val toBeMapped = Either.ofRight<String, ScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Source Kind to pull the configuration data from.
     */
    @JvmName("futleyiawumkvrmy")
    public suspend fun sourceKind(`value`: Either<String, SourceKindType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceKind = mapped
    }

    /**
     * @param value Source Kind to pull the configuration data from.
     */
    @JvmName("qmrggchmoogdwvyk")
    public fun sourceKind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SourceKindType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceKind = mapped
    }

    /**
     * @param value Source Kind to pull the configuration data from.
     */
    @JvmName("wxhaygnwhisjidet")
    public fun sourceKind(`value`: SourceKindType) {
        val toBeMapped = Either.ofRight<String, SourceKindType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceKind = mapped
    }

    /**
     * @param value Whether this configuration should suspend its reconciliation of its kustomizations and sources.
     */
    @JvmName("rptmyoqtejsdrwgx")
    public suspend fun `suspend`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`suspend` = mapped
    }

    /**
     * @param value Whether flux configuration deployment should wait for cluster to reconcile the kustomizations.
     */
    @JvmName("xxwjupgnjuofcmti")
    public suspend fun waitForReconciliation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForReconciliation = mapped
    }

    internal fun build(): FluxConfigurationArgs = FluxConfigurationArgs(
        azureBlob = azureBlob,
        bucket = bucket,
        clusterName = clusterName,
        clusterResourceName = clusterResourceName,
        clusterRp = clusterRp,
        configurationProtectedSettings = configurationProtectedSettings,
        fluxConfigurationName = fluxConfigurationName,
        gitRepository = gitRepository,
        kustomizations = kustomizations,
        namespace = namespace,
        reconciliationWaitDuration = reconciliationWaitDuration,
        resourceGroupName = resourceGroupName,
        scope = scope,
        sourceKind = sourceKind,
        `suspend` = `suspend`,
        waitForReconciliation = waitForReconciliation,
    )
}
