@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.AzureBlobDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Parameters to reconcile to the AzureBlob source kind type.
 * @property accountKey The account key (shared key) to access the storage account
 * @property containerName The Azure Blob container name to sync from the url endpoint for the flux configuration.
 * @property localAuthRef Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
 * @property managedIdentity Parameters to authenticate using a Managed Identity.
 * @property sasToken The Shared Access token to access the storage container
 * @property servicePrincipal Parameters to authenticate using Service Principal.
 * @property syncIntervalInSeconds The interval at which to re-reconcile the cluster Azure Blob source with the remote.
 * @property timeoutInSeconds The maximum time to attempt to reconcile the cluster Azure Blob source with the remote.
 * @property url The URL to sync for the flux configuration Azure Blob storage account.
 */
public data class AzureBlobDefinitionArgs(
    public val accountKey: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val localAuthRef: Output<String>? = null,
    public val managedIdentity: Output<ManagedIdentityDefinitionArgs>? = null,
    public val sasToken: Output<String>? = null,
    public val servicePrincipal: Output<ServicePrincipalDefinitionArgs>? = null,
    public val syncIntervalInSeconds: Output<Double>? = null,
    public val timeoutInSeconds: Output<Double>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.AzureBlobDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.AzureBlobDefinitionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.AzureBlobDefinitionArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .localAuthRef(localAuthRef?.applyValue({ args0 -> args0 }))
            .managedIdentity(managedIdentity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasToken(sasToken?.applyValue({ args0 -> args0 }))
            .servicePrincipal(servicePrincipal?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .syncIntervalInSeconds(syncIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBlobDefinitionArgs].
 */
@PulumiTagMarker
public class AzureBlobDefinitionArgsBuilder internal constructor() {
    private var accountKey: Output<String>? = null

    private var containerName: Output<String>? = null

    private var localAuthRef: Output<String>? = null

    private var managedIdentity: Output<ManagedIdentityDefinitionArgs>? = null

    private var sasToken: Output<String>? = null

    private var servicePrincipal: Output<ServicePrincipalDefinitionArgs>? = null

    private var syncIntervalInSeconds: Output<Double>? = null

    private var timeoutInSeconds: Output<Double>? = null

    private var url: Output<String>? = null

    /**
     * @param value The account key (shared key) to access the storage account
     */
    @JvmName("mchdaxwbfnopfomb")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value The Azure Blob container name to sync from the url endpoint for the flux configuration.
     */
    @JvmName("cilxvddqslpuaaxr")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
     */
    @JvmName("shjpgajcvrwnydrd")
    public suspend fun localAuthRef(`value`: Output<String>) {
        this.localAuthRef = value
    }

    /**
     * @param value Parameters to authenticate using a Managed Identity.
     */
    @JvmName("grflnflppkvnhggn")
    public suspend fun managedIdentity(`value`: Output<ManagedIdentityDefinitionArgs>) {
        this.managedIdentity = value
    }

    /**
     * @param value The Shared Access token to access the storage container
     */
    @JvmName("duwunwglmutvhhti")
    public suspend fun sasToken(`value`: Output<String>) {
        this.sasToken = value
    }

    /**
     * @param value Parameters to authenticate using Service Principal.
     */
    @JvmName("xyilkussguouylnu")
    public suspend fun servicePrincipal(`value`: Output<ServicePrincipalDefinitionArgs>) {
        this.servicePrincipal = value
    }

    /**
     * @param value The interval at which to re-reconcile the cluster Azure Blob source with the remote.
     */
    @JvmName("ktyhytcmdcowcklc")
    public suspend fun syncIntervalInSeconds(`value`: Output<Double>) {
        this.syncIntervalInSeconds = value
    }

    /**
     * @param value The maximum time to attempt to reconcile the cluster Azure Blob source with the remote.
     */
    @JvmName("vvexgrxeeiubeknu")
    public suspend fun timeoutInSeconds(`value`: Output<Double>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value The URL to sync for the flux configuration Azure Blob storage account.
     */
    @JvmName("qapwjmrogtgfyflh")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The account key (shared key) to access the storage account
     */
    @JvmName("rrwracnkfttklsuv")
    public suspend fun accountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value The Azure Blob container name to sync from the url endpoint for the flux configuration.
     */
    @JvmName("trxgihcwxlxladui")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
     */
    @JvmName("bpewhltanahptqac")
    public suspend fun localAuthRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localAuthRef = mapped
    }

    /**
     * @param value Parameters to authenticate using a Managed Identity.
     */
    @JvmName("axlltdqowhvfnxdt")
    public suspend fun managedIdentity(`value`: ManagedIdentityDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedIdentity = mapped
    }

    /**
     * @param argument Parameters to authenticate using a Managed Identity.
     */
    @JvmName("hjeelqkdacqjscqw")
    public suspend
    fun managedIdentity(argument: suspend ManagedIdentityDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedIdentity = mapped
    }

    /**
     * @param value The Shared Access token to access the storage container
     */
    @JvmName("xiehtyuimbhblele")
    public suspend fun sasToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param value Parameters to authenticate using Service Principal.
     */
    @JvmName("jklwswkdbeelmlpu")
    public suspend fun servicePrincipal(`value`: ServicePrincipalDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipal = mapped
    }

    /**
     * @param argument Parameters to authenticate using Service Principal.
     */
    @JvmName("ujpmpkknqpxpwfsm")
    public suspend
    fun servicePrincipal(argument: suspend ServicePrincipalDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ServicePrincipalDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipal = mapped
    }

    /**
     * @param value The interval at which to re-reconcile the cluster Azure Blob source with the remote.
     */
    @JvmName("cxbiypijxyutkfkp")
    public suspend fun syncIntervalInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncIntervalInSeconds = mapped
    }

    /**
     * @param value The maximum time to attempt to reconcile the cluster Azure Blob source with the remote.
     */
    @JvmName("jouevpmebojpaoxs")
    public suspend fun timeoutInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value The URL to sync for the flux configuration Azure Blob storage account.
     */
    @JvmName("lmpgixgaixrhlayg")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): AzureBlobDefinitionArgs = AzureBlobDefinitionArgs(
        accountKey = accountKey,
        containerName = containerName,
        localAuthRef = localAuthRef,
        managedIdentity = managedIdentity,
        sasToken = sasToken,
        servicePrincipal = servicePrincipal,
        syncIntervalInSeconds = syncIntervalInSeconds,
        timeoutInSeconds = timeoutInSeconds,
        url = url,
    )
}
