@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.ExtensionAksAssignedIdentityArgs.builder
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.enums.AKSIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity of the Extension resource in an AKS cluster
 * @property type The identity type.
 */
public data class ExtensionAksAssignedIdentityArgs(
    public val type: Output<AKSIdentityType>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.ExtensionAksAssignedIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.ExtensionAksAssignedIdentityArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.ExtensionAksAssignedIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ExtensionAksAssignedIdentityArgs].
 */
@PulumiTagMarker
public class ExtensionAksAssignedIdentityArgsBuilder internal constructor() {
    private var type: Output<AKSIdentityType>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("kocsyxtapdcclwya")
    public suspend fun type(`value`: Output<AKSIdentityType>) {
        this.type = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("otorifsrvmchmfph")
    public suspend fun type(`value`: AKSIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExtensionAksAssignedIdentityArgs = ExtensionAksAssignedIdentityArgs(
        type = type,
    )
}
