@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.ManagedIdentityDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters to authenticate using a Managed Identity.
 * @property clientId The client Id for authenticating a Managed Identity.
 */
public data class ManagedIdentityDefinitionArgs(
    public val clientId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.ManagedIdentityDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.ManagedIdentityDefinitionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.ManagedIdentityDefinitionArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIdentityDefinitionArgs].
 */
@PulumiTagMarker
public class ManagedIdentityDefinitionArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    /**
     * @param value The client Id for authenticating a Managed Identity.
     */
    @JvmName("klheoeqwaytfyysh")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The client Id for authenticating a Managed Identity.
     */
    @JvmName("ueswxkfotxotrnak")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    internal fun build(): ManagedIdentityDefinitionArgs = ManagedIdentityDefinitionArgs(
        clientId = clientId,
    )
}
