@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.PostBuildDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The postBuild definitions defining variable substitutions for this Kustomization after kustomize build.
 * @property substitute Key/value pairs holding the variables to be substituted in this Kustomization.
 * @property substituteFrom Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
 */
public data class PostBuildDefinitionArgs(
    public val substitute: Output<Map<String, String>>? = null,
    public val substituteFrom: Output<List<SubstituteFromDefinitionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.PostBuildDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.kubernetesconfiguration.inputs.PostBuildDefinitionArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.PostBuildDefinitionArgs.builder()
            .substitute(
                substitute?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .substituteFrom(
                substituteFrom?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PostBuildDefinitionArgs].
 */
@PulumiTagMarker
public class PostBuildDefinitionArgsBuilder internal constructor() {
    private var substitute: Output<Map<String, String>>? = null

    private var substituteFrom: Output<List<SubstituteFromDefinitionArgs>>? = null

    /**
     * @param value Key/value pairs holding the variables to be substituted in this Kustomization.
     */
    @JvmName("ywuyuuwbyuwpsdyn")
    public suspend fun substitute(`value`: Output<Map<String, String>>) {
        this.substitute = value
    }

    /**
     * @param value Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
     */
    @JvmName("hcdsqotfoyhwoeyw")
    public suspend fun substituteFrom(`value`: Output<List<SubstituteFromDefinitionArgs>>) {
        this.substituteFrom = value
    }

    @JvmName("lijbhrooycnpatpk")
    public suspend fun substituteFrom(vararg values: Output<SubstituteFromDefinitionArgs>) {
        this.substituteFrom = Output.all(values.asList())
    }

    /**
     * @param values Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
     */
    @JvmName("jjluvalnobohkbsa")
    public suspend fun substituteFrom(values: List<Output<SubstituteFromDefinitionArgs>>) {
        this.substituteFrom = Output.all(values)
    }

    /**
     * @param value Key/value pairs holding the variables to be substituted in this Kustomization.
     */
    @JvmName("enyaxsyqvrsjfclm")
    public suspend fun substitute(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.substitute = mapped
    }

    /**
     * @param values Key/value pairs holding the variables to be substituted in this Kustomization.
     */
    @JvmName("gimdimeafvdmiffv")
    public fun substitute(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.substitute = mapped
    }

    /**
     * @param value Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
     */
    @JvmName("xyuotwasmqodepbd")
    public suspend fun substituteFrom(`value`: List<SubstituteFromDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.substituteFrom = mapped
    }

    /**
     * @param argument Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
     */
    @JvmName("jimkotmnwfkurkwg")
    public suspend
    fun substituteFrom(argument: List<suspend SubstituteFromDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubstituteFromDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.substituteFrom = mapped
    }

    /**
     * @param argument Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
     */
    @JvmName("djjblgisttrajape")
    public suspend fun substituteFrom(
        vararg
        argument: suspend SubstituteFromDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SubstituteFromDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.substituteFrom = mapped
    }

    /**
     * @param argument Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
     */
    @JvmName("compjurdtthiungm")
    public suspend
    fun substituteFrom(argument: suspend SubstituteFromDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SubstituteFromDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.substituteFrom = mapped
    }

    /**
     * @param values Array of ConfigMaps/Secrets from which the variables are substituted for this Kustomization.
     */
    @JvmName("clgkmplkomnbmdgw")
    public suspend fun substituteFrom(vararg values: SubstituteFromDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.substituteFrom = mapped
    }

    internal fun build(): PostBuildDefinitionArgs = PostBuildDefinitionArgs(
        substitute = substitute,
        substituteFrom = substituteFrom,
    )
}
