@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Parameters to authenticate using Service Principal.
 * @property clientCertificate Base64-encoded certificate used to authenticate a Service Principal
 * @property clientCertificatePassword The password for the certificate used to authenticate a Service Principal
 * @property clientCertificateSendChain Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the Client Certificate
 * @property clientId The client Id for authenticating a Service Principal.
 * @property clientSecret The client secret for authenticating a Service Principal
 * @property tenantId The tenant Id for authenticating a Service Principal
 */
public data class ServicePrincipalDefinitionResponse(
    public val clientCertificate: String? = null,
    public val clientCertificatePassword: String? = null,
    public val clientCertificateSendChain: Boolean? = null,
    public val clientId: String? = null,
    public val clientSecret: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ServicePrincipalDefinitionResponse):
            ServicePrincipalDefinitionResponse = ServicePrincipalDefinitionResponse(
            clientCertificate = javaType.clientCertificate().map({ args0 -> args0 }).orElse(null),
            clientCertificatePassword = javaType.clientCertificatePassword().map({ args0 ->
                args0
            }).orElse(null),
            clientCertificateSendChain = javaType.clientCertificateSendChain().map({ args0 ->
                args0
            }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
