@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.SandboxCustomImageArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.Language
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a Kusto sandbox custom image.
 * Azure REST API version: 2023-08-15.
 * ## Example Usage
 * ### KustoSandboxCustomImagesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sandboxCustomImage = new AzureNative.Kusto.SandboxCustomImage("sandboxCustomImage", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         Language = "Python",
 *         LanguageVersion = "3.10.8",
 *         RequirementsFileContent = "Requests",
 *         ResourceGroupName = "kustorptest",
 *         SandboxCustomImageName = "customImage8",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewSandboxCustomImage(ctx, "sandboxCustomImage", &kusto.SandboxCustomImageArgs{
 * 			ClusterName:             pulumi.String("kustoCluster"),
 * 			Language:                pulumi.String("Python"),
 * 			LanguageVersion:         pulumi.String("3.10.8"),
 * 			RequirementsFileContent: pulumi.String("Requests"),
 * 			ResourceGroupName:       pulumi.String("kustorptest"),
 * 			SandboxCustomImageName:  pulumi.String("customImage8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.SandboxCustomImage;
 * import com.pulumi.azurenative.kusto.SandboxCustomImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sandboxCustomImage = new SandboxCustomImage("sandboxCustomImage", SandboxCustomImageArgs.builder()
 *             .clusterName("kustoCluster")
 *             .language("Python")
 *             .languageVersion("3.10.8")
 *             .requirementsFileContent("Requests")
 *             .resourceGroupName("kustorptest")
 *             .sandboxCustomImageName("customImage8")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:SandboxCustomImage kustoCluster/customImage8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/sandboxCustomImages/{sandboxCustomImageName}
 * ```
 * @property clusterName The name of the Kusto cluster.
 * @property language The language name, for example Python.
 * @property languageVersion The version of the language.
 * @property requirementsFileContent The requirements file content.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sandboxCustomImageName The name of the sandbox custom image.
 */
public data class SandboxCustomImageArgs(
    public val clusterName: Output<String>? = null,
    public val language: Output<Either<String, Language>>? = null,
    public val languageVersion: Output<String>? = null,
    public val requirementsFileContent: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sandboxCustomImageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.SandboxCustomImageArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.SandboxCustomImageArgs =
        com.pulumi.azurenative.kusto.SandboxCustomImageArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .language(
                language?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .languageVersion(languageVersion?.applyValue({ args0 -> args0 }))
            .requirementsFileContent(requirementsFileContent?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sandboxCustomImageName(sandboxCustomImageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SandboxCustomImageArgs].
 */
@PulumiTagMarker
public class SandboxCustomImageArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var language: Output<Either<String, Language>>? = null

    private var languageVersion: Output<String>? = null

    private var requirementsFileContent: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sandboxCustomImageName: Output<String>? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("prykhkifloxxaate")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The language name, for example Python.
     */
    @JvmName("rvapwrctqaqncbid")
    public suspend fun language(`value`: Output<Either<String, Language>>) {
        this.language = value
    }

    /**
     * @param value The version of the language.
     */
    @JvmName("ccvqduhgduwcjrhm")
    public suspend fun languageVersion(`value`: Output<String>) {
        this.languageVersion = value
    }

    /**
     * @param value The requirements file content.
     */
    @JvmName("wadkqpfhbaleutyr")
    public suspend fun requirementsFileContent(`value`: Output<String>) {
        this.requirementsFileContent = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tkwvdttpmpaodujb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the sandbox custom image.
     */
    @JvmName("nksyvuxjpigwwggs")
    public suspend fun sandboxCustomImageName(`value`: Output<String>) {
        this.sandboxCustomImageName = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("ebamhsbxnrxbklad")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The language name, for example Python.
     */
    @JvmName("gtbgexsqnhthxvfg")
    public suspend fun language(`value`: Either<String, Language>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value The language name, for example Python.
     */
    @JvmName("iybaodyemmenvopb")
    public fun language(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Language>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value The language name, for example Python.
     */
    @JvmName("owdstpglyocxples")
    public fun language(`value`: Language) {
        val toBeMapped = Either.ofRight<String, Language>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value The version of the language.
     */
    @JvmName("qnaaxmquvtdeoiuc")
    public suspend fun languageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageVersion = mapped
    }

    /**
     * @param value The requirements file content.
     */
    @JvmName("beqrjimwahfffonp")
    public suspend fun requirementsFileContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requirementsFileContent = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xpbjfoapfibvrgyg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the sandbox custom image.
     */
    @JvmName("vjrpjjecrtmstvvf")
    public suspend fun sandboxCustomImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sandboxCustomImageName = mapped
    }

    internal fun build(): SandboxCustomImageArgs = SandboxCustomImageArgs(
        clusterName = clusterName,
        language = language,
        languageVersion = languageVersion,
        requirementsFileContent = requirementsFileContent,
        resourceGroupName = resourceGroupName,
        sandboxCustomImageName = sandboxCustomImageName,
    )
}
