@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The language name, for example Python.
 */
public enum class Language(
    public val javaValue: com.pulumi.azurenative.kusto.enums.Language,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.Language> {
    Python(com.pulumi.azurenative.kusto.enums.Language.Python),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.Language = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.Language): Language =
            Language.values().first { it.javaValue == javaType }
    }
}
