@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.GetDatabasePrincipalAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Kusto cluster.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property principalAssignmentName The name of the Kusto principalAssignment.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class GetDatabasePrincipalAssignmentPlainArgs(
    public val clusterName: String,
    public val databaseName: String,
    public val principalAssignmentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.GetDatabasePrincipalAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.GetDatabasePrincipalAssignmentPlainArgs =
        com.pulumi.azurenative.kusto.inputs.GetDatabasePrincipalAssignmentPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .principalAssignmentName(principalAssignmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatabasePrincipalAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetDatabasePrincipalAssignmentPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var databaseName: String? = null

    private var principalAssignmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("anjhcbkgvomatmve")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("eibljmjrbetjalxc")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("rrkmcodujsysqpci")
    public suspend fun principalAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalAssignmentName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("tgvbeiuwqubndrxu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDatabasePrincipalAssignmentPlainArgs =
        GetDatabasePrincipalAssignmentPlainArgs(
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            principalAssignmentName = principalAssignmentName ?: throw
                PulumiNullFieldException("principalAssignmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
