@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.OptimizedAutoscaleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A class that contains the optimized auto scale definition.
 * @property isEnabled A boolean value that indicate if the optimized autoscale feature is enabled or not.
 * @property maximum Maximum allowed instances count.
 * @property minimum Minimum allowed instances count.
 * @property version The version of the template defined, for instance 1.
 */
public data class OptimizedAutoscaleArgs(
    public val isEnabled: Output<Boolean>,
    public val maximum: Output<Int>,
    public val minimum: Output<Int>,
    public val version: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.OptimizedAutoscaleArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.OptimizedAutoscaleArgs =
        com.pulumi.azurenative.kusto.inputs.OptimizedAutoscaleArgs.builder()
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .maximum(maximum.applyValue({ args0 -> args0 }))
            .minimum(minimum.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OptimizedAutoscaleArgs].
 */
@PulumiTagMarker
public class OptimizedAutoscaleArgsBuilder internal constructor() {
    private var isEnabled: Output<Boolean>? = null

    private var maximum: Output<Int>? = null

    private var minimum: Output<Int>? = null

    private var version: Output<Int>? = null

    /**
     * @param value A boolean value that indicate if the optimized autoscale feature is enabled or not.
     */
    @JvmName("ttoiiunjwigoxgiq")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Maximum allowed instances count.
     */
    @JvmName("volvgedtdnowyqph")
    public suspend fun maximum(`value`: Output<Int>) {
        this.maximum = value
    }

    /**
     * @param value Minimum allowed instances count.
     */
    @JvmName("vvglmxjyxskuwpse")
    public suspend fun minimum(`value`: Output<Int>) {
        this.minimum = value
    }

    /**
     * @param value The version of the template defined, for instance 1.
     */
    @JvmName("dicboqbxgindlmcd")
    public suspend fun version(`value`: Output<Int>) {
        this.version = value
    }

    /**
     * @param value A boolean value that indicate if the optimized autoscale feature is enabled or not.
     */
    @JvmName("nwepbnjciiowenek")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Maximum allowed instances count.
     */
    @JvmName("shasmqfdvqqrrqsg")
    public suspend fun maximum(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximum = mapped
    }

    /**
     * @param value Minimum allowed instances count.
     */
    @JvmName("yhomxkvfoypnwwhu")
    public suspend fun minimum(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimum = mapped
    }

    /**
     * @param value The version of the template defined, for instance 1.
     */
    @JvmName("wpfwggwdcectbebc")
    public suspend fun version(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): OptimizedAutoscaleArgs = OptimizedAutoscaleArgs(
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        maximum = maximum ?: throw PulumiNullFieldException("maximum"),
        minimum = minimum ?: throw PulumiNullFieldException("minimum"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
