@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class representing an event hub data connection.
 * @property compression The event hub messages compression type
 * @property consumerGroup The event hub consumer group.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property databaseRouting Indication for database routing information from the data connection, by default only database routing information is allowed
 * @property eventHubResourceId The resource ID of the event hub to be used to create a data connection.
 * @property eventSystemProperties System properties of the event hub
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'EventHub'.
 * @property location Resource location.
 * @property managedIdentityObjectId The object ID of the managedIdentityResourceId
 * @property managedIdentityResourceId The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property name The name of the resource
 * @property provisioningState The provisioned state of the resource.
 * @property retrievalStartDate When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period.
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEventHubDataConnectionResult(
    public val compression: String? = null,
    public val consumerGroup: String,
    public val dataFormat: String? = null,
    public val databaseRouting: String? = null,
    public val eventHubResourceId: String,
    public val eventSystemProperties: List<String>? = null,
    public val id: String,
    public val kind: String,
    public val location: String? = null,
    public val managedIdentityObjectId: String,
    public val managedIdentityResourceId: String? = null,
    public val mappingRuleName: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val retrievalStartDate: String? = null,
    public val tableName: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.GetEventHubDataConnectionResult):
            GetEventHubDataConnectionResult = GetEventHubDataConnectionResult(
            compression = javaType.compression().map({ args0 -> args0 }).orElse(null),
            consumerGroup = javaType.consumerGroup(),
            dataFormat = javaType.dataFormat().map({ args0 -> args0 }).orElse(null),
            databaseRouting = javaType.databaseRouting().map({ args0 -> args0 }).orElse(null),
            eventHubResourceId = javaType.eventHubResourceId(),
            eventSystemProperties = javaType.eventSystemProperties().map({ args0 -> args0 }),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedIdentityObjectId = javaType.managedIdentityObjectId(),
            managedIdentityResourceId = javaType.managedIdentityResourceId().map({ args0 ->
                args0
            }).orElse(null),
            mappingRuleName = javaType.mappingRuleName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            retrievalStartDate = javaType.retrievalStartDate().map({ args0 -> args0 }).orElse(null),
            tableName = javaType.tableName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
