@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.EnvironmentSettingArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.ConfigurationState
import com.pulumi.azurenative.labservices.kotlin.inputs.ResourceSettingsArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.ResourceSettingsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents settings of an environment, from which environment instances would be created
 * Azure REST API version: 2018-10-15. Prior API version in Azure Native 1.x: 2018-10-15.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:EnvironmentSetting myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labaccounts/{labAccountName}/labs/{labName}/environmentsettings/{environmentSettingName}
 * ```
 * @property configurationState Describes the user's progress in configuring their environment setting
 * @property description Describes the environment and its resource settings
 * @property environmentSettingName The name of the environment Setting.
 * @property labAccountName The name of the lab Account.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property resourceGroupName The name of the resource group.
 * @property resourceSettings The resource specific settings
 * @property tags The tags of the resource.
 * @property title Brief title describing the environment and its resource settings
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class EnvironmentSettingArgs(
    public val configurationState: Output<Either<String, ConfigurationState>>? = null,
    public val description: Output<String>? = null,
    public val environmentSettingName: Output<String>? = null,
    public val labAccountName: Output<String>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceSettings: Output<ResourceSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val title: Output<String>? = null,
    public val uniqueIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.EnvironmentSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.EnvironmentSettingArgs =
        com.pulumi.azurenative.labservices.EnvironmentSettingArgs.builder()
            .configurationState(
                configurationState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentSettingName(environmentSettingName?.applyValue({ args0 -> args0 }))
            .labAccountName(labAccountName?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceSettings(resourceSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .title(title?.applyValue({ args0 -> args0 }))
            .uniqueIdentifier(uniqueIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentSettingArgs].
 */
@PulumiTagMarker
public class EnvironmentSettingArgsBuilder internal constructor() {
    private var configurationState: Output<Either<String, ConfigurationState>>? = null

    private var description: Output<String>? = null

    private var environmentSettingName: Output<String>? = null

    private var labAccountName: Output<String>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceSettings: Output<ResourceSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var title: Output<String>? = null

    private var uniqueIdentifier: Output<String>? = null

    /**
     * @param value Describes the user's progress in configuring their environment setting
     */
    @JvmName("oijftdhdnlveljlf")
    public suspend fun configurationState(`value`: Output<Either<String, ConfigurationState>>) {
        this.configurationState = value
    }

    /**
     * @param value Describes the environment and its resource settings
     */
    @JvmName("fgycrjljlsqtobmm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the environment Setting.
     */
    @JvmName("wrsvlqfwtiejerhp")
    public suspend fun environmentSettingName(`value`: Output<String>) {
        this.environmentSettingName = value
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("rnpfqfhfrqamjsuo")
    public suspend fun labAccountName(`value`: Output<String>) {
        this.labAccountName = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("yjonsxhpdhubujlr")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("mudytqfqjnfkopko")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The provisioning status of the resource.
     */
    @JvmName("kopftknsxdshdfgw")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wgnhiucxhthoetak")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource specific settings
     */
    @JvmName("pfapclhrgiqoljlo")
    public suspend fun resourceSettings(`value`: Output<ResourceSettingsArgs>) {
        this.resourceSettings = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("evounqdvracbxsat")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Brief title describing the environment and its resource settings
     */
    @JvmName("ucudmarlkpniebkj")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The unique immutable identifier of a resource (Guid).
     */
    @JvmName("eoegpyxnckevldhw")
    public suspend fun uniqueIdentifier(`value`: Output<String>) {
        this.uniqueIdentifier = value
    }

    /**
     * @param value Describes the user's progress in configuring their environment setting
     */
    @JvmName("setoksptbhtbuixj")
    public suspend fun configurationState(`value`: Either<String, ConfigurationState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationState = mapped
    }

    /**
     * @param value Describes the user's progress in configuring their environment setting
     */
    @JvmName("bdmmkauwuffdjgji")
    public fun configurationState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConfigurationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationState = mapped
    }

    /**
     * @param value Describes the user's progress in configuring their environment setting
     */
    @JvmName("njwxqimyvfneoium")
    public fun configurationState(`value`: ConfigurationState) {
        val toBeMapped = Either.ofRight<String, ConfigurationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationState = mapped
    }

    /**
     * @param value Describes the environment and its resource settings
     */
    @JvmName("vgnafkmdvgpbrnui")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the environment Setting.
     */
    @JvmName("vnqltnqdruemsdvn")
    public suspend fun environmentSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentSettingName = mapped
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("uujkaqjmgkddbifh")
    public suspend fun labAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labAccountName = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("wudbwdndiqwmomda")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("ucxproldsalntrss")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The provisioning status of the resource.
     */
    @JvmName("bjjviwqlrdxhryna")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ntjsbbyhtfnqhseh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource specific settings
     */
    @JvmName("iwwhresvwcgkcplg")
    public suspend fun resourceSettings(`value`: ResourceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSettings = mapped
    }

    /**
     * @param argument The resource specific settings
     */
    @JvmName("xcyxsvtoxiqpvkkg")
    public suspend fun resourceSettings(argument: suspend ResourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceSettings = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("owhckeveekdqyhyb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("fbejdhamfpcwfale")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Brief title describing the environment and its resource settings
     */
    @JvmName("xwvqkaoabstgiiab")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The unique immutable identifier of a resource (Guid).
     */
    @JvmName("qhaqkafsduwrrfjr")
    public suspend fun uniqueIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueIdentifier = mapped
    }

    internal fun build(): EnvironmentSettingArgs = EnvironmentSettingArgs(
        configurationState = configurationState,
        description = description,
        environmentSettingName = environmentSettingName,
        labAccountName = labAccountName,
        labName = labName,
        location = location,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        resourceSettings = resourceSettings,
        tags = tags,
        title = title,
        uniqueIdentifier = uniqueIdentifier,
    )
}
