@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.LabPlanArgs.builder
import com.pulumi.azurenative.labservices.kotlin.inputs.AutoShutdownProfileArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.AutoShutdownProfileArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.ConnectionProfileArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.ConnectionProfileArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.LabPlanNetworkProfileArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.LabPlanNetworkProfileArgsBuilder
import com.pulumi.azurenative.labservices.kotlin.inputs.SupportInfoArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.SupportInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Lab Plans act as a permission container for creating labs via labs.azure.com. Additionally, they can provide a set of default configurations that will apply at the time of creating a lab, but these defaults can still be overwritten.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-10-01-preview.
 * Other available API versions: 2023-06-07.
 * ## Example Usage
 * ### putLabPlan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var labPlan = new AzureNative.LabServices.LabPlan("labPlan", new()
 *     {
 *         DefaultAutoShutdownProfile = new AzureNative.LabServices.Inputs.AutoShutdownProfileArgs
 *         {
 *             DisconnectDelay = "PT5M",
 *             IdleDelay = "PT5M",
 *             NoConnectDelay = "PT5M",
 *             ShutdownOnDisconnect = AzureNative.LabServices.EnableState.Enabled,
 *             ShutdownOnIdle = AzureNative.LabServices.ShutdownOnIdleMode.UserAbsence,
 *             ShutdownWhenNotConnected = AzureNative.LabServices.EnableState.Enabled,
 *         },
 *         DefaultConnectionProfile = new AzureNative.LabServices.Inputs.ConnectionProfileArgs
 *         {
 *             ClientRdpAccess = AzureNative.LabServices.ConnectionType.Public,
 *             ClientSshAccess = AzureNative.LabServices.ConnectionType.Public,
 *             WebRdpAccess = AzureNative.LabServices.ConnectionType.None,
 *             WebSshAccess = AzureNative.LabServices.ConnectionType.None,
 *         },
 *         DefaultNetworkProfile = new AzureNative.LabServices.Inputs.LabPlanNetworkProfileArgs
 *         {
 *             SubnetId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default",
 *         },
 *         LabPlanName = "testlabplan",
 *         Location = "westus",
 *         ResourceGroupName = "testrg123",
 *         SharedGalleryId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Compute/galleries/testsig",
 *         SupportInfo = new AzureNative.LabServices.Inputs.SupportInfoArgs
 *         {
 *             Email = "help@contoso.com",
 *             Instructions = "Contact support for help.",
 *             Phone = "+1-202-555-0123",
 *             Url = "help.contoso.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/labservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := labservices.NewLabPlan(ctx, "labPlan", &labservices.LabPlanArgs{
 * 			DefaultAutoShutdownProfile: &labservices.AutoShutdownProfileArgs{
 * 				DisconnectDelay:          pulumi.String("PT5M"),
 * 				IdleDelay:                pulumi.String("PT5M"),
 * 				NoConnectDelay:           pulumi.String("PT5M"),
 * 				ShutdownOnDisconnect:     labservices.EnableStateEnabled,
 * 				ShutdownOnIdle:           labservices.ShutdownOnIdleModeUserAbsence,
 * 				ShutdownWhenNotConnected: labservices.EnableStateEnabled,
 * 			},
 * 			DefaultConnectionProfile: &labservices.ConnectionProfileArgs{
 * 				ClientRdpAccess: labservices.ConnectionTypePublic,
 * 				ClientSshAccess: labservices.ConnectionTypePublic,
 * 				WebRdpAccess:    labservices.ConnectionTypeNone,
 * 				WebSshAccess:    labservices.ConnectionTypeNone,
 * 			},
 * 			DefaultNetworkProfile: &labservices.LabPlanNetworkProfileArgs{
 * 				SubnetId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"),
 * 			},
 * 			LabPlanName:       pulumi.String("testlabplan"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			SharedGalleryId:   pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Compute/galleries/testsig"),
 * 			SupportInfo: &labservices.SupportInfoArgs{
 * 				Email:        pulumi.String("help@contoso.com"),
 * 				Instructions: pulumi.String("Contact support for help."),
 * 				Phone:        pulumi.String("+1-202-555-0123"),
 * 				Url:          pulumi.String("help.contoso.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.labservices.LabPlan;
 * import com.pulumi.azurenative.labservices.LabPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var labPlan = new LabPlan("labPlan", LabPlanArgs.builder()
 *             .defaultAutoShutdownProfile(Map.ofEntries(
 *                 Map.entry("disconnectDelay", "PT5M"),
 *                 Map.entry("idleDelay", "PT5M"),
 *                 Map.entry("noConnectDelay", "PT5M"),
 *                 Map.entry("shutdownOnDisconnect", "Enabled"),
 *                 Map.entry("shutdownOnIdle", "UserAbsence"),
 *                 Map.entry("shutdownWhenNotConnected", "Enabled")
 *             ))
 *             .defaultConnectionProfile(Map.ofEntries(
 *                 Map.entry("clientRdpAccess", "Public"),
 *                 Map.entry("clientSshAccess", "Public"),
 *                 Map.entry("webRdpAccess", "None"),
 *                 Map.entry("webSshAccess", "None")
 *             ))
 *             .defaultNetworkProfile(Map.of("subnetId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"))
 *             .labPlanName("testlabplan")
 *             .location("westus")
 *             .resourceGroupName("testrg123")
 *             .sharedGalleryId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Compute/galleries/testsig")
 *             .supportInfo(Map.ofEntries(
 *                 Map.entry("email", "help@contoso.com"),
 *                 Map.entry("instructions", "Contact support for help."),
 *                 Map.entry("phone", "+1-202-555-0123"),
 *                 Map.entry("url", "help.contoso.com")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:LabPlan testlabplan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labPlans/{labPlanName}
 * ```
 * @property allowedRegions The allowed regions for the lab creator to use when creating labs using this lab plan.
 * @property defaultAutoShutdownProfile The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
 * @property defaultConnectionProfile The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
 * @property defaultNetworkProfile The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan.
 * @property identity Managed Identity Information
 * @property labPlanName The name of the lab plan that uniquely identifies it within containing resource group. Used in resource URIs and in UI.
 * @property linkedLmsInstance Base Url of the lms instance this lab plan can link lab rosters against.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sharedGalleryId Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it will be persisted in this gallery. Shared images from the gallery can be made available to use when creating new labs.
 * @property supportInfo Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan.
 * @property tags Resource tags.
 */
public data class LabPlanArgs(
    public val allowedRegions: Output<List<String>>? = null,
    public val defaultAutoShutdownProfile: Output<AutoShutdownProfileArgs>? = null,
    public val defaultConnectionProfile: Output<ConnectionProfileArgs>? = null,
    public val defaultNetworkProfile: Output<LabPlanNetworkProfileArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val labPlanName: Output<String>? = null,
    public val linkedLmsInstance: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sharedGalleryId: Output<String>? = null,
    public val supportInfo: Output<SupportInfoArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.LabPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.LabPlanArgs =
        com.pulumi.azurenative.labservices.LabPlanArgs.builder()
            .allowedRegions(allowedRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .defaultAutoShutdownProfile(
                defaultAutoShutdownProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultConnectionProfile(
                defaultConnectionProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultNetworkProfile(
                defaultNetworkProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labPlanName(labPlanName?.applyValue({ args0 -> args0 }))
            .linkedLmsInstance(linkedLmsInstance?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sharedGalleryId(sharedGalleryId?.applyValue({ args0 -> args0 }))
            .supportInfo(supportInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LabPlanArgs].
 */
@PulumiTagMarker
public class LabPlanArgsBuilder internal constructor() {
    private var allowedRegions: Output<List<String>>? = null

    private var defaultAutoShutdownProfile: Output<AutoShutdownProfileArgs>? = null

    private var defaultConnectionProfile: Output<ConnectionProfileArgs>? = null

    private var defaultNetworkProfile: Output<LabPlanNetworkProfileArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var labPlanName: Output<String>? = null

    private var linkedLmsInstance: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sharedGalleryId: Output<String>? = null

    private var supportInfo: Output<SupportInfoArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The allowed regions for the lab creator to use when creating labs using this lab plan.
     */
    @JvmName("ajvthdusxjlnkxdi")
    public suspend fun allowedRegions(`value`: Output<List<String>>) {
        this.allowedRegions = value
    }

    @JvmName("kybgfnasmtfanemc")
    public suspend fun allowedRegions(vararg values: Output<String>) {
        this.allowedRegions = Output.all(values.asList())
    }

    /**
     * @param values The allowed regions for the lab creator to use when creating labs using this lab plan.
     */
    @JvmName("wmjxdbldjkbfycea")
    public suspend fun allowedRegions(values: List<Output<String>>) {
        this.allowedRegions = Output.all(values)
    }

    /**
     * @param value The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
     */
    @JvmName("igyqprxjsiscsnsa")
    public suspend fun defaultAutoShutdownProfile(`value`: Output<AutoShutdownProfileArgs>) {
        this.defaultAutoShutdownProfile = value
    }

    /**
     * @param value The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
     */
    @JvmName("vfauetthinlikghx")
    public suspend fun defaultConnectionProfile(`value`: Output<ConnectionProfileArgs>) {
        this.defaultConnectionProfile = value
    }

    /**
     * @param value The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan.
     */
    @JvmName("cdtpqhfthbmfyeon")
    public suspend fun defaultNetworkProfile(`value`: Output<LabPlanNetworkProfileArgs>) {
        this.defaultNetworkProfile = value
    }

    /**
     * @param value Managed Identity Information
     */
    @JvmName("uugxhnayddibquwc")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The name of the lab plan that uniquely identifies it within containing resource group. Used in resource URIs and in UI.
     */
    @JvmName("raeavylmwwvvnhcc")
    public suspend fun labPlanName(`value`: Output<String>) {
        this.labPlanName = value
    }

    /**
     * @param value Base Url of the lms instance this lab plan can link lab rosters against.
     */
    @JvmName("hfhbykbbegfgqfpt")
    public suspend fun linkedLmsInstance(`value`: Output<String>) {
        this.linkedLmsInstance = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jhmqowpdvotnvwko")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mewjouvyrlrdrggg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it will be persisted in this gallery. Shared images from the gallery can be made available to use when creating new labs.
     */
    @JvmName("ohyttturrwhgrphw")
    public suspend fun sharedGalleryId(`value`: Output<String>) {
        this.sharedGalleryId = value
    }

    /**
     * @param value Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan.
     */
    @JvmName("vxgygtuvfmuaolba")
    public suspend fun supportInfo(`value`: Output<SupportInfoArgs>) {
        this.supportInfo = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("augnxmqqfmuaqrwj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The allowed regions for the lab creator to use when creating labs using this lab plan.
     */
    @JvmName("ufdvlttbsiaiumxv")
    public suspend fun allowedRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedRegions = mapped
    }

    /**
     * @param values The allowed regions for the lab creator to use when creating labs using this lab plan.
     */
    @JvmName("kkgcjlhkervhgqay")
    public suspend fun allowedRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedRegions = mapped
    }

    /**
     * @param value The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
     */
    @JvmName("vtywjslnfhupwakf")
    public suspend fun defaultAutoShutdownProfile(`value`: AutoShutdownProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAutoShutdownProfile = mapped
    }

    /**
     * @param argument The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
     */
    @JvmName("kofybcyhvldxkuhe")
    public suspend
    fun defaultAutoShutdownProfile(argument: suspend AutoShutdownProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AutoShutdownProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultAutoShutdownProfile = mapped
    }

    /**
     * @param value The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
     */
    @JvmName("irqybfbgjshbsthg")
    public suspend fun defaultConnectionProfile(`value`: ConnectionProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultConnectionProfile = mapped
    }

    /**
     * @param argument The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
     */
    @JvmName("uslbfkydesvjqkws")
    public suspend
    fun defaultConnectionProfile(argument: suspend ConnectionProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultConnectionProfile = mapped
    }

    /**
     * @param value The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan.
     */
    @JvmName("uofhxmmmjadtfsbi")
    public suspend fun defaultNetworkProfile(`value`: LabPlanNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultNetworkProfile = mapped
    }

    /**
     * @param argument The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan.
     */
    @JvmName("fkomxeolleoxnoyn")
    public suspend
    fun defaultNetworkProfile(argument: suspend LabPlanNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = LabPlanNetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultNetworkProfile = mapped
    }

    /**
     * @param value Managed Identity Information
     */
    @JvmName("fyssvegvvjctkvao")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed Identity Information
     */
    @JvmName("hfuyuntjuurdwrgq")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name of the lab plan that uniquely identifies it within containing resource group. Used in resource URIs and in UI.
     */
    @JvmName("yprkhafvlaqabveh")
    public suspend fun labPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labPlanName = mapped
    }

    /**
     * @param value Base Url of the lms instance this lab plan can link lab rosters against.
     */
    @JvmName("lptbidweelxowocb")
    public suspend fun linkedLmsInstance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedLmsInstance = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lduebjimamwenegv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ktdmdbjltngrkqeu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it will be persisted in this gallery. Shared images from the gallery can be made available to use when creating new labs.
     */
    @JvmName("scxvpjohdhullqfp")
    public suspend fun sharedGalleryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedGalleryId = mapped
    }

    /**
     * @param value Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan.
     */
    @JvmName("xvjdlxlpssguujpd")
    public suspend fun supportInfo(`value`: SupportInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportInfo = mapped
    }

    /**
     * @param argument Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan.
     */
    @JvmName("pmjdeasiayceplsx")
    public suspend fun supportInfo(argument: suspend SupportInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SupportInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.supportInfo = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("khgvfftxrmbluhey")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("sxegaderejismyoh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LabPlanArgs = LabPlanArgs(
        allowedRegions = allowedRegions,
        defaultAutoShutdownProfile = defaultAutoShutdownProfile,
        defaultConnectionProfile = defaultConnectionProfile,
        defaultNetworkProfile = defaultNetworkProfile,
        identity = identity,
        labPlanName = labPlanName,
        linkedLmsInstance = linkedLmsInstance,
        location = location,
        resourceGroupName = resourceGroupName,
        sharedGalleryId = sharedGalleryId,
        supportInfo = supportInfo,
        tags = tags,
    )
}
