@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.kotlin.outputs.RecurrencePatternResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.labservices.kotlin.outputs.RecurrencePatternResponse.Companion.toKotlin as recurrencePatternResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Schedule].
 */
@PulumiTagMarker
public class ScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleArgs = ScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleArgsBuilder.() -> Unit) {
        val builder = ScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Schedule {
        val builtJavaResource = com.pulumi.azurenative.labservices.Schedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schedule(builtJavaResource)
    }
}

/**
 * Schedule for automatically turning virtual machines in a lab on and off at specified times.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-10-01-preview.
 * Other available API versions: 2023-06-07.
 * ## Example Usage
 * ### putSchedule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.LabServices.Schedule("schedule", new()
 *     {
 *         LabName = "testlab",
 *         Notes = "Schedule 1 for students",
 *         RecurrencePattern = new AzureNative.LabServices.Inputs.RecurrencePatternArgs
 *         {
 *             ExpirationDate = "2020-08-14T23:59:59Z",
 *             Frequency = AzureNative.LabServices.RecurrenceFrequency.Daily,
 *             Interval = 2,
 *         },
 *         ResourceGroupName = "testrg123",
 *         ScheduleName = "schedule1",
 *         StartAt = "2020-05-26T12:00:00Z",
 *         StopAt = "2020-05-26T18:00:00Z",
 *         TimeZoneId = "America/Los_Angeles",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/labservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := labservices.NewSchedule(ctx, "schedule", &labservices.ScheduleArgs{
 * 			LabName: pulumi.String("testlab"),
 * 			Notes:   pulumi.String("Schedule 1 for students"),
 * 			RecurrencePattern: &labservices.RecurrencePatternArgs{
 * 				ExpirationDate: pulumi.String("2020-08-14T23:59:59Z"),
 * 				Frequency:      labservices.RecurrenceFrequencyDaily,
 * 				Interval:       pulumi.Int(2),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			ScheduleName:      pulumi.String("schedule1"),
 * 			StartAt:           pulumi.String("2020-05-26T12:00:00Z"),
 * 			StopAt:            pulumi.String("2020-05-26T18:00:00Z"),
 * 			TimeZoneId:        pulumi.String("America/Los_Angeles"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.labservices.Schedule;
 * import com.pulumi.azurenative.labservices.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .labName("testlab")
 *             .notes("Schedule 1 for students")
 *             .recurrencePattern(Map.ofEntries(
 *                 Map.entry("expirationDate", "2020-08-14T23:59:59Z"),
 *                 Map.entry("frequency", "Daily"),
 *                 Map.entry("interval", 2)
 *             ))
 *             .resourceGroupName("testrg123")
 *             .scheduleName("schedule1")
 *             .startAt("2020-05-26T12:00:00Z")
 *             .stopAt("2020-05-26T18:00:00Z")
 *             .timeZoneId("America/Los_Angeles")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:Schedule schedule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/schedules/{scheduleName}
 * ```
 */
public class Schedule internal constructor(
    override val javaResource: com.pulumi.azurenative.labservices.Schedule,
) : KotlinCustomResource(javaResource, ScheduleMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Notes for this schedule.
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Current provisioning state of the schedule.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The recurrence pattern of the scheduled actions.
     */
    public val recurrencePattern: Output<RecurrencePatternResponse>?
        get() = javaResource.recurrencePattern().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> recurrencePatternResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead.
     */
    public val startAt: Output<String>?
        get() = javaResource.startAt().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead.
     */
    public val stopAt: Output<String>
        get() = javaResource.stopAt().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the schedule.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The IANA timezone id for the schedule.
     */
    public val timeZoneId: Output<String>
        get() = javaResource.timeZoneId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScheduleMapper : ResourceMapper<Schedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.labservices.Schedule::class == javaResource::class

    override fun map(javaResource: Resource): Schedule = Schedule(
        javaResource as
            com.pulumi.azurenative.labservices.Schedule,
    )
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schedule].
 */
public suspend fun schedule(name: String, block: suspend ScheduleResourceBuilder.() -> Unit):
    Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedule(name: String): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
