@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [User].
 */
@PulumiTagMarker
public class UserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserArgs = UserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserArgsBuilder.() -> Unit) {
        val builder = UserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): User {
        val builtJavaResource = com.pulumi.azurenative.labservices.User(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return User(builtJavaResource)
    }
}

/**
 * User of a lab that can register for and use virtual machines within the lab.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2018-10-15.
 * Other available API versions: 2018-10-15, 2023-06-07.
 * ## Example Usage
 * ### putUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AzureNative.LabServices.User("user", new()
 *     {
 *         AdditionalUsageQuota = "PT10H",
 *         Email = "testuser@contoso.com",
 *         LabName = "testlab",
 *         ResourceGroupName = "testrg123",
 *         UserName = "testuser",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/labservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := labservices.NewUser(ctx, "user", &labservices.UserArgs{
 * 			AdditionalUsageQuota: pulumi.String("PT10H"),
 * 			Email:                pulumi.String("testuser@contoso.com"),
 * 			LabName:              pulumi.String("testlab"),
 * 			ResourceGroupName:    pulumi.String("testrg123"),
 * 			UserName:             pulumi.String("testuser"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.labservices.User;
 * import com.pulumi.azurenative.labservices.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .additionalUsageQuota("PT10H")
 *             .email("testuser@contoso.com")
 *             .labName("testlab")
 *             .resourceGroupName("testrg123")
 *             .userName("testuser")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:User default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/users/{userName}
 * ```
 */
public class User internal constructor(
    override val javaResource: com.pulumi.azurenative.labservices.User,
) : KotlinCustomResource(javaResource, UserMapper) {
    /**
     * The amount of usage quota time the user gets in addition to the lab usage quota.
     */
    public val additionalUsageQuota: Output<String>?
        get() = javaResource.additionalUsageQuota().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Display name of the user, for example user's full name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Email address of the user.
     */
    public val email: Output<String>
        get() = javaResource.email().applyValue({ args0 -> args0 })

    /**
     * Date and time when the invitation message was sent to the user.
     */
    public val invitationSent: Output<String>
        get() = javaResource.invitationSent().applyValue({ args0 -> args0 })

    /**
     * State of the invitation message for the user.
     */
    public val invitationState: Output<String>
        get() = javaResource.invitationState().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Current provisioning state of the user resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * State of the user's registration within the lab.
     */
    public val registrationState: Output<String>
        get() = javaResource.registrationState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the user resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * How long the user has used their virtual machines in this lab.
     */
    public val totalUsage: Output<String>
        get() = javaResource.totalUsage().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object UserMapper : ResourceMapper<User> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.labservices.User::class == javaResource::class

    override fun map(javaResource: Resource): User = User(
        javaResource as
            com.pulumi.azurenative.labservices.User,
    )
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [User].
 */
public suspend fun user(name: String, block: suspend UserResourceBuilder.() -> Unit): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 */
public fun user(name: String): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    return builder.build()
}
