@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.UserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User of a lab that can register for and use virtual machines within the lab.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2018-10-15.
 * Other available API versions: 2018-10-15, 2023-06-07.
 * ## Example Usage
 * ### putUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AzureNative.LabServices.User("user", new()
 *     {
 *         AdditionalUsageQuota = "PT10H",
 *         Email = "testuser@contoso.com",
 *         LabName = "testlab",
 *         ResourceGroupName = "testrg123",
 *         UserName = "testuser",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/labservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := labservices.NewUser(ctx, "user", &labservices.UserArgs{
 * 			AdditionalUsageQuota: pulumi.String("PT10H"),
 * 			Email:                pulumi.String("testuser@contoso.com"),
 * 			LabName:              pulumi.String("testlab"),
 * 			ResourceGroupName:    pulumi.String("testrg123"),
 * 			UserName:             pulumi.String("testuser"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.labservices.User;
 * import com.pulumi.azurenative.labservices.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .additionalUsageQuota("PT10H")
 *             .email("testuser@contoso.com")
 *             .labName("testlab")
 *             .resourceGroupName("testrg123")
 *             .userName("testuser")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:User default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}/users/{userName}
 * ```
 * @property additionalUsageQuota The amount of usage quota time the user gets in addition to the lab usage quota.
 * @property email Email address of the user.
 * @property labName The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property userName The name of the user that uniquely identifies it within containing lab. Used in resource URIs.
 */
public data class UserArgs(
    public val additionalUsageQuota: Output<String>? = null,
    public val email: Output<String>? = null,
    public val labName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.UserArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.UserArgs =
        com.pulumi.azurenative.labservices.UserArgs.builder()
            .additionalUsageQuota(additionalUsageQuota?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var additionalUsageQuota: Output<String>? = null

    private var email: Output<String>? = null

    private var labName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The amount of usage quota time the user gets in addition to the lab usage quota.
     */
    @JvmName("ylgmnuuctakdofss")
    public suspend fun additionalUsageQuota(`value`: Output<String>) {
        this.additionalUsageQuota = value
    }

    /**
     * @param value Email address of the user.
     */
    @JvmName("llrljhvtsinefqrd")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     */
    @JvmName("dphiwdrhrayhbgnj")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xrfmetrlvpmgyewk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the user that uniquely identifies it within containing lab. Used in resource URIs.
     */
    @JvmName("dpimecbydyyjpqji")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The amount of usage quota time the user gets in addition to the lab usage quota.
     */
    @JvmName("xewjjkpnhpismoui")
    public suspend fun additionalUsageQuota(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalUsageQuota = mapped
    }

    /**
     * @param value Email address of the user.
     */
    @JvmName("midiswouhpxmgfdq")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     */
    @JvmName("nfmtlmnvqvkcvtjy")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wqpajxayucbbuphf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the user that uniquely identifies it within containing lab. Used in resource URIs.
     */
    @JvmName("nlflgohmgdqhsljw")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        additionalUsageQuota = additionalUsageQuota,
        email = email,
        labName = labName,
        resourceGroupName = resourceGroupName,
        userName = userName,
    )
}
