@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Days of the week.
 */
public enum class WeekDay(
    public val javaValue: com.pulumi.azurenative.labservices.enums.WeekDay,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.WeekDay> {
    /**
     * Schedule will run on Sunday
     */
    Sunday(com.pulumi.azurenative.labservices.enums.WeekDay.Sunday),

    /**
     * Schedule will run on Monday
     */
    Monday(com.pulumi.azurenative.labservices.enums.WeekDay.Monday),

    /**
     * Schedule will run on Tuesday
     */
    Tuesday(com.pulumi.azurenative.labservices.enums.WeekDay.Tuesday),

    /**
     * Schedule will run on Wednesday
     */
    Wednesday(com.pulumi.azurenative.labservices.enums.WeekDay.Wednesday),

    /**
     * Schedule will run on Thursday
     */
    Thursday(com.pulumi.azurenative.labservices.enums.WeekDay.Thursday),

    /**
     * Schedule will run on Friday
     */
    Friday(com.pulumi.azurenative.labservices.enums.WeekDay.Friday),

    /**
     * Schedule will run on Saturday
     */
    Saturday(com.pulumi.azurenative.labservices.enums.WeekDay.Saturday),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.WeekDay = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.WeekDay): WeekDay =
            WeekDay.values().first { it.javaValue == javaType }
    }
}
