@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.AutoShutdownProfileArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.EnableState
import com.pulumi.azurenative.labservices.kotlin.enums.ShutdownOnIdleMode
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Profile for how to handle shutting down virtual machines.
 * @property disconnectDelay The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
 * @property idleDelay The amount of time a VM will idle before it is shutdown if this behavior is enabled.
 * @property noConnectDelay The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
 * @property shutdownOnDisconnect Whether shutdown on disconnect is enabled
 * @property shutdownOnIdle Whether a VM will get shutdown when it has idled for a period of time.
 * @property shutdownWhenNotConnected Whether a VM will get shutdown when it hasn't been connected to after a period of time.
 */
public data class AutoShutdownProfileArgs(
    public val disconnectDelay: Output<String>? = null,
    public val idleDelay: Output<String>? = null,
    public val noConnectDelay: Output<String>? = null,
    public val shutdownOnDisconnect: Output<EnableState>? = null,
    public val shutdownOnIdle: Output<ShutdownOnIdleMode>? = null,
    public val shutdownWhenNotConnected: Output<EnableState>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.AutoShutdownProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.AutoShutdownProfileArgs =
        com.pulumi.azurenative.labservices.inputs.AutoShutdownProfileArgs.builder()
            .disconnectDelay(disconnectDelay?.applyValue({ args0 -> args0 }))
            .idleDelay(idleDelay?.applyValue({ args0 -> args0 }))
            .noConnectDelay(noConnectDelay?.applyValue({ args0 -> args0 }))
            .shutdownOnDisconnect(
                shutdownOnDisconnect?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .shutdownOnIdle(shutdownOnIdle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .shutdownWhenNotConnected(
                shutdownWhenNotConnected?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AutoShutdownProfileArgs].
 */
@PulumiTagMarker
public class AutoShutdownProfileArgsBuilder internal constructor() {
    private var disconnectDelay: Output<String>? = null

    private var idleDelay: Output<String>? = null

    private var noConnectDelay: Output<String>? = null

    private var shutdownOnDisconnect: Output<EnableState>? = null

    private var shutdownOnIdle: Output<ShutdownOnIdleMode>? = null

    private var shutdownWhenNotConnected: Output<EnableState>? = null

    /**
     * @param value The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
     */
    @JvmName("wsderbsamhobhbpk")
    public suspend fun disconnectDelay(`value`: Output<String>) {
        this.disconnectDelay = value
    }

    /**
     * @param value The amount of time a VM will idle before it is shutdown if this behavior is enabled.
     */
    @JvmName("eqgtxcbxyvgxurlt")
    public suspend fun idleDelay(`value`: Output<String>) {
        this.idleDelay = value
    }

    /**
     * @param value The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
     */
    @JvmName("ithpxmmribiiuxur")
    public suspend fun noConnectDelay(`value`: Output<String>) {
        this.noConnectDelay = value
    }

    /**
     * @param value Whether shutdown on disconnect is enabled
     */
    @JvmName("fhokxfstdhbcyxrm")
    public suspend fun shutdownOnDisconnect(`value`: Output<EnableState>) {
        this.shutdownOnDisconnect = value
    }

    /**
     * @param value Whether a VM will get shutdown when it has idled for a period of time.
     */
    @JvmName("ognvbnhsakthjwvv")
    public suspend fun shutdownOnIdle(`value`: Output<ShutdownOnIdleMode>) {
        this.shutdownOnIdle = value
    }

    /**
     * @param value Whether a VM will get shutdown when it hasn't been connected to after a period of time.
     */
    @JvmName("nbdjmpvergslfndp")
    public suspend fun shutdownWhenNotConnected(`value`: Output<EnableState>) {
        this.shutdownWhenNotConnected = value
    }

    /**
     * @param value The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
     */
    @JvmName("wqrwgvadbeoncgwa")
    public suspend fun disconnectDelay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disconnectDelay = mapped
    }

    /**
     * @param value The amount of time a VM will idle before it is shutdown if this behavior is enabled.
     */
    @JvmName("bdfcxgkfsymphscn")
    public suspend fun idleDelay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleDelay = mapped
    }

    /**
     * @param value The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
     */
    @JvmName("gckmpgnunoledbbu")
    public suspend fun noConnectDelay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noConnectDelay = mapped
    }

    /**
     * @param value Whether shutdown on disconnect is enabled
     */
    @JvmName("qylciapetrpoxtjf")
    public suspend fun shutdownOnDisconnect(`value`: EnableState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shutdownOnDisconnect = mapped
    }

    /**
     * @param value Whether a VM will get shutdown when it has idled for a period of time.
     */
    @JvmName("sxmjrygfwqesbydc")
    public suspend fun shutdownOnIdle(`value`: ShutdownOnIdleMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shutdownOnIdle = mapped
    }

    /**
     * @param value Whether a VM will get shutdown when it hasn't been connected to after a period of time.
     */
    @JvmName("oytbxdtbrefqbmxu")
    public suspend fun shutdownWhenNotConnected(`value`: EnableState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shutdownWhenNotConnected = mapped
    }

    internal fun build(): AutoShutdownProfileArgs = AutoShutdownProfileArgs(
        disconnectDelay = disconnectDelay,
        idleDelay = idleDelay,
        noConnectDelay = noConnectDelay,
        shutdownOnDisconnect = shutdownOnDisconnect,
        shutdownOnIdle = shutdownOnIdle,
        shutdownWhenNotConnected = shutdownWhenNotConnected,
    )
}
