@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.ConnectionProfileArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.ConnectionType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connection profile for how users connect to lab virtual machines.
 * @property clientRdpAccess The enabled access level for Client Access over RDP.
 * @property clientSshAccess The enabled access level for Client Access over SSH.
 * @property webRdpAccess The enabled access level for Web Access over RDP.
 * @property webSshAccess The enabled access level for Web Access over SSH.
 */
public data class ConnectionProfileArgs(
    public val clientRdpAccess: Output<ConnectionType>? = null,
    public val clientSshAccess: Output<ConnectionType>? = null,
    public val webRdpAccess: Output<ConnectionType>? = null,
    public val webSshAccess: Output<ConnectionType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.ConnectionProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.ConnectionProfileArgs =
        com.pulumi.azurenative.labservices.inputs.ConnectionProfileArgs.builder()
            .clientRdpAccess(clientRdpAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clientSshAccess(clientSshAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webRdpAccess(webRdpAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webSshAccess(webSshAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectionProfileArgs].
 */
@PulumiTagMarker
public class ConnectionProfileArgsBuilder internal constructor() {
    private var clientRdpAccess: Output<ConnectionType>? = null

    private var clientSshAccess: Output<ConnectionType>? = null

    private var webRdpAccess: Output<ConnectionType>? = null

    private var webSshAccess: Output<ConnectionType>? = null

    /**
     * @param value The enabled access level for Client Access over RDP.
     */
    @JvmName("egsasragfhoemwji")
    public suspend fun clientRdpAccess(`value`: Output<ConnectionType>) {
        this.clientRdpAccess = value
    }

    /**
     * @param value The enabled access level for Client Access over SSH.
     */
    @JvmName("rbyfmjhjhqtwbmeb")
    public suspend fun clientSshAccess(`value`: Output<ConnectionType>) {
        this.clientSshAccess = value
    }

    /**
     * @param value The enabled access level for Web Access over RDP.
     */
    @JvmName("drrgixdmjakhgque")
    public suspend fun webRdpAccess(`value`: Output<ConnectionType>) {
        this.webRdpAccess = value
    }

    /**
     * @param value The enabled access level for Web Access over SSH.
     */
    @JvmName("sjqobnyypidmlgie")
    public suspend fun webSshAccess(`value`: Output<ConnectionType>) {
        this.webSshAccess = value
    }

    /**
     * @param value The enabled access level for Client Access over RDP.
     */
    @JvmName("vpcnhrkakxxnujdg")
    public suspend fun clientRdpAccess(`value`: ConnectionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientRdpAccess = mapped
    }

    /**
     * @param value The enabled access level for Client Access over SSH.
     */
    @JvmName("tvrtcggrpimtolgg")
    public suspend fun clientSshAccess(`value`: ConnectionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSshAccess = mapped
    }

    /**
     * @param value The enabled access level for Web Access over RDP.
     */
    @JvmName("fdjlywysnaoxnsru")
    public suspend fun webRdpAccess(`value`: ConnectionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webRdpAccess = mapped
    }

    /**
     * @param value The enabled access level for Web Access over SSH.
     */
    @JvmName("rskcwhvnbxnbrusd")
    public suspend fun webSshAccess(`value`: ConnectionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webSshAccess = mapped
    }

    internal fun build(): ConnectionProfileArgs = ConnectionProfileArgs(
        clientRdpAccess = clientRdpAccess,
        clientSshAccess = clientSshAccess,
        webRdpAccess = webRdpAccess,
        webSshAccess = webSshAccess,
    )
}
