@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.CredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Credentials for a user on a lab VM.
 * @property password The password for the user. This is required for the TemplateVM createOption.
 * @property username The username to use when signing in to lab VMs.
 */
public data class CredentialsArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.CredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.CredentialsArgs =
        com.pulumi.azurenative.labservices.inputs.CredentialsArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CredentialsArgs].
 */
@PulumiTagMarker
public class CredentialsArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password for the user. This is required for the TemplateVM createOption.
     */
    @JvmName("paltonacumtiskiu")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The username to use when signing in to lab VMs.
     */
    @JvmName("vtlhyfgotnviuwxy")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password for the user. This is required for the TemplateVM createOption.
     */
    @JvmName("relivbabakxrdcfa")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The username to use when signing in to lab VMs.
     */
    @JvmName("ojqhhytghekswsuo")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): CredentialsArgs = CredentialsArgs(
        password = password,
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
