@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetGlobalUserEnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentId The resourceId of the environment
 * @property expand Specify the $expand query. Example: 'properties($expand=environment)'
 * @property userName The name of the user.
 */
public data class GetGlobalUserEnvironmentPlainArgs(
    public val environmentId: String,
    public val expand: String? = null,
    public val userName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetGlobalUserEnvironmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.GetGlobalUserEnvironmentPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetGlobalUserEnvironmentPlainArgs.builder()
            .environmentId(environmentId.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalUserEnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalUserEnvironmentPlainArgsBuilder internal constructor() {
    private var environmentId: String? = null

    private var expand: String? = null

    private var userName: String? = null

    /**
     * @param value The resourceId of the environment
     */
    @JvmName("fmabmrlovjhnrdui")
    public suspend fun environmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentId = mapped
    }

    /**
     * @param value Specify the $expand query. Example: 'properties($expand=environment)'
     */
    @JvmName("cjepckuwljavksdc")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the user.
     */
    @JvmName("uiqbcrnlkmhvmsii")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetGlobalUserEnvironmentPlainArgs = GetGlobalUserEnvironmentPlainArgs(
        environmentId = environmentId ?: throw PulumiNullFieldException("environmentId"),
        expand = expand,
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
