@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetGlobalUserOperationStatusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property operationUrl The operation url of long running operation
 * @property userName The name of the user.
 */
public data class GetGlobalUserOperationStatusPlainArgs(
    public val operationUrl: String,
    public val userName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetGlobalUserOperationStatusPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.labservices.inputs.GetGlobalUserOperationStatusPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetGlobalUserOperationStatusPlainArgs.builder()
            .operationUrl(operationUrl.let({ args0 -> args0 }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalUserOperationStatusPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalUserOperationStatusPlainArgsBuilder internal constructor() {
    private var operationUrl: String? = null

    private var userName: String? = null

    /**
     * @param value The operation url of long running operation
     */
    @JvmName("nxnctxyfsvutiwhn")
    public suspend fun operationUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.operationUrl = mapped
    }

    /**
     * @param value The name of the user.
     */
    @JvmName("tpqkmlbuvbmqbohm")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetGlobalUserOperationStatusPlainArgs =
        GetGlobalUserOperationStatusPlainArgs(
            operationUrl = operationUrl ?: throw PulumiNullFieldException("operationUrl"),
            userName = userName ?: throw PulumiNullFieldException("userName"),
        )
}
