@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetLabAccountRegionalAvailabilityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property labAccountName The name of the lab Account.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetLabAccountRegionalAvailabilityPlainArgs(
    public val labAccountName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetLabAccountRegionalAvailabilityPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.labservices.inputs.GetLabAccountRegionalAvailabilityPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetLabAccountRegionalAvailabilityPlainArgs.builder()
            .labAccountName(labAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLabAccountRegionalAvailabilityPlainArgs].
 */
@PulumiTagMarker
public class GetLabAccountRegionalAvailabilityPlainArgsBuilder internal constructor() {
    private var labAccountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("dpndvnqaecdodmfo")
    public suspend fun labAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labAccountName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("antouabwxdmoqjey")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLabAccountRegionalAvailabilityPlainArgs =
        GetLabAccountRegionalAvailabilityPlainArgs(
            labAccountName = labAccountName ?: throw PulumiNullFieldException("labAccountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
