@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetLabPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property labName The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLabPlainArgs(
    public val labName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetLabPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.GetLabPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetLabPlainArgs.builder()
            .labName(labName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLabPlainArgs].
 */
@PulumiTagMarker
public class GetLabPlainArgsBuilder internal constructor() {
    private var labName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs.
     */
    @JvmName("wxomdcnvlarolpcs")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ckamjgbsobthaltt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLabPlainArgs = GetLabPlainArgs(
        labName = labName ?: throw PulumiNullFieldException("labName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
