@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.SecurityProfileArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.EnableState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The lab security profile.
 * @property openAccess Whether any user or only specified users can register to a lab.
 */
public data class SecurityProfileArgs(
    public val openAccess: Output<EnableState>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.SecurityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.SecurityProfileArgs =
        com.pulumi.azurenative.labservices.inputs.SecurityProfileArgs.builder()
            .openAccess(openAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SecurityProfileArgs].
 */
@PulumiTagMarker
public class SecurityProfileArgsBuilder internal constructor() {
    private var openAccess: Output<EnableState>? = null

    /**
     * @param value Whether any user or only specified users can register to a lab.
     */
    @JvmName("jhjmujhpoemspydy")
    public suspend fun openAccess(`value`: Output<EnableState>) {
        this.openAccess = value
    }

    /**
     * @param value Whether any user or only specified users can register to a lab.
     */
    @JvmName("ddbvtxncynkghlfu")
    public suspend fun openAccess(`value`: EnableState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openAccess = mapped
    }

    internal fun build(): SecurityProfileArgs = SecurityProfileArgs(
        openAccess = openAccess,
    )
}
