@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.SkuArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.SkuTier
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The resource model definition representing SKU
 * @property capacity If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
 * @property family If the service has different generations of hardware, for the same SKU, then that can be captured here.
 * @property name The name of the SKU. Ex - P3. It is typically a letter+number code
 * @property size The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
 * @property tier This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
 */
public data class SkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>,
    public val size: Output<String>? = null,
    public val tier: Output<SkuTier>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.SkuArgs =
        com.pulumi.azurenative.labservices.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var size: Output<String>? = null

    private var tier: Output<SkuTier>? = null

    /**
     * @param value If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
     */
    @JvmName("cnqjjuiwfuveqvlc")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    @JvmName("ikjhembmxxjbquod")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the SKU. Ex - P3. It is typically a letter+number code
     */
    @JvmName("yitdxndsslcwtxcj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
     */
    @JvmName("lcepolsdgtrrgjow")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
     */
    @JvmName("kicdaqvbscnrpxqt")
    public suspend fun tier(`value`: Output<SkuTier>) {
        this.tier = value
    }

    /**
     * @param value If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
     */
    @JvmName("kngaulkkjbgnxjjp")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    @JvmName("pwqitfabalhvwapq")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the SKU. Ex - P3. It is typically a letter+number code
     */
    @JvmName("bdxlgeskeexaggcs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
     */
    @JvmName("bdrusfdwwoosxbym")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
     */
    @JvmName("vskbxobyyqsdyuid")
    public suspend fun tier(`value`: SkuTier?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
        size = size,
        tier = tier,
    )
}
