@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.VirtualMachineProfileArgs.builder
import com.pulumi.azurenative.labservices.kotlin.enums.CreateOption
import com.pulumi.azurenative.labservices.kotlin.enums.EnableState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The base virtual machine configuration for a lab.
 * @property additionalCapabilities Additional VM capabilities.
 * @property adminUser Credentials for the admin user on the VM.
 * @property createOption Indicates what lab virtual machines are created from.
 * @property imageReference The image configuration for lab virtual machines.
 * @property nonAdminUser Credentials for the non-admin user on the VM, if one exists.
 * @property sku The SKU for the lab. Defines the type of virtual machines used in the lab.
 * @property usageQuota The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours.
 * @property useSharedPassword Enabling this option will use the same password for all user VMs.
 */
public data class VirtualMachineProfileArgs(
    public val additionalCapabilities: Output<VirtualMachineAdditionalCapabilitiesArgs>? = null,
    public val adminUser: Output<CredentialsArgs>,
    public val createOption: Output<CreateOption>,
    public val imageReference: Output<ImageReferenceArgs>,
    public val nonAdminUser: Output<CredentialsArgs>? = null,
    public val sku: Output<SkuArgs>,
    public val usageQuota: Output<String>,
    public val useSharedPassword: Output<EnableState>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.VirtualMachineProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.VirtualMachineProfileArgs =
        com.pulumi.azurenative.labservices.inputs.VirtualMachineProfileArgs.builder()
            .additionalCapabilities(
                additionalCapabilities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .adminUser(adminUser.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .createOption(createOption.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageReference(imageReference.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nonAdminUser(nonAdminUser?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .usageQuota(usageQuota.applyValue({ args0 -> args0 }))
            .useSharedPassword(
                useSharedPassword?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineProfileArgsBuilder internal constructor() {
    private var additionalCapabilities: Output<VirtualMachineAdditionalCapabilitiesArgs>? = null

    private var adminUser: Output<CredentialsArgs>? = null

    private var createOption: Output<CreateOption>? = null

    private var imageReference: Output<ImageReferenceArgs>? = null

    private var nonAdminUser: Output<CredentialsArgs>? = null

    private var sku: Output<SkuArgs>? = null

    private var usageQuota: Output<String>? = null

    private var useSharedPassword: Output<EnableState>? = null

    /**
     * @param value Additional VM capabilities.
     */
    @JvmName("rmlqddwsowiihyte")
    public suspend
    fun additionalCapabilities(`value`: Output<VirtualMachineAdditionalCapabilitiesArgs>) {
        this.additionalCapabilities = value
    }

    /**
     * @param value Credentials for the admin user on the VM.
     */
    @JvmName("vwaasxcobffqcyev")
    public suspend fun adminUser(`value`: Output<CredentialsArgs>) {
        this.adminUser = value
    }

    /**
     * @param value Indicates what lab virtual machines are created from.
     */
    @JvmName("utgdlkpxonoiueui")
    public suspend fun createOption(`value`: Output<CreateOption>) {
        this.createOption = value
    }

    /**
     * @param value The image configuration for lab virtual machines.
     */
    @JvmName("swcmfhdtofqambbw")
    public suspend fun imageReference(`value`: Output<ImageReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value Credentials for the non-admin user on the VM, if one exists.
     */
    @JvmName("chunjogltavucuby")
    public suspend fun nonAdminUser(`value`: Output<CredentialsArgs>) {
        this.nonAdminUser = value
    }

    /**
     * @param value The SKU for the lab. Defines the type of virtual machines used in the lab.
     */
    @JvmName("qlxpmpfhbqfrimal")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours.
     */
    @JvmName("qjabxamghgqnjgal")
    public suspend fun usageQuota(`value`: Output<String>) {
        this.usageQuota = value
    }

    /**
     * @param value Enabling this option will use the same password for all user VMs.
     */
    @JvmName("tmeberjhvshivicc")
    public suspend fun useSharedPassword(`value`: Output<EnableState>) {
        this.useSharedPassword = value
    }

    /**
     * @param value Additional VM capabilities.
     */
    @JvmName("fqdabixltaiepwpy")
    public suspend fun additionalCapabilities(`value`: VirtualMachineAdditionalCapabilitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalCapabilities = mapped
    }

    /**
     * @param argument Additional VM capabilities.
     */
    @JvmName("cyfcbbvpgaxyrlos")
    public suspend
    fun additionalCapabilities(argument: suspend VirtualMachineAdditionalCapabilitiesArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineAdditionalCapabilitiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.additionalCapabilities = mapped
    }

    /**
     * @param value Credentials for the admin user on the VM.
     */
    @JvmName("mtkcqagdlkaxskpd")
    public suspend fun adminUser(`value`: CredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminUser = mapped
    }

    /**
     * @param argument Credentials for the admin user on the VM.
     */
    @JvmName("hsahmmfgnpbuyrgw")
    public suspend fun adminUser(argument: suspend CredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.adminUser = mapped
    }

    /**
     * @param value Indicates what lab virtual machines are created from.
     */
    @JvmName("mtiwmxjyhkltvtie")
    public suspend fun createOption(`value`: CreateOption) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value The image configuration for lab virtual machines.
     */
    @JvmName("uodoomiefckseqfh")
    public suspend fun imageReference(`value`: ImageReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument The image configuration for lab virtual machines.
     */
    @JvmName("vmaygrudwsjwolde")
    public suspend fun imageReference(argument: suspend ImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ImageReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value Credentials for the non-admin user on the VM, if one exists.
     */
    @JvmName("swvdpwhwmjfjyunn")
    public suspend fun nonAdminUser(`value`: CredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonAdminUser = mapped
    }

    /**
     * @param argument Credentials for the non-admin user on the VM, if one exists.
     */
    @JvmName("iyjnvcmexbvnwwvg")
    public suspend fun nonAdminUser(argument: suspend CredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nonAdminUser = mapped
    }

    /**
     * @param value The SKU for the lab. Defines the type of virtual machines used in the lab.
     */
    @JvmName("ujwtddhnyidneusg")
    public suspend fun sku(`value`: SkuArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU for the lab. Defines the type of virtual machines used in the lab.
     */
    @JvmName("ipilbcduuheycrha")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours.
     */
    @JvmName("uvvipodoejbntacy")
    public suspend fun usageQuota(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usageQuota = mapped
    }

    /**
     * @param value Enabling this option will use the same password for all user VMs.
     */
    @JvmName("befaokrakdcaixdm")
    public suspend fun useSharedPassword(`value`: EnableState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSharedPassword = mapped
    }

    internal fun build(): VirtualMachineProfileArgs = VirtualMachineProfileArgs(
        additionalCapabilities = additionalCapabilities,
        adminUser = adminUser ?: throw PulumiNullFieldException("adminUser"),
        createOption = createOption ?: throw PulumiNullFieldException("createOption"),
        imageReference = imageReference ?: throw PulumiNullFieldException("imageReference"),
        nonAdminUser = nonAdminUser,
        sku = sku ?: throw PulumiNullFieldException("sku"),
        usageQuota = usageQuota ?: throw PulumiNullFieldException("usageQuota"),
        useSharedPassword = useSharedPassword,
    )
}
