@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Profile for how to handle networking for Lab Plans.
 * @property subnetId The external subnet resource id
 */
public data class LabPlanNetworkProfileResponse(
    public val subnetId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.LabPlanNetworkProfileResponse):
            LabPlanNetworkProfileResponse = LabPlanNetworkProfileResponse(
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
