@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Recurrence pattern of a lab schedule.
 * @property expirationDate When the recurrence will expire. This date is inclusive.
 * @property frequency The frequency of the recurrence.
 * @property interval The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days. When no interval is supplied, an interval of 1 is used.
 * @property weekDays The week days the schedule runs. Used for when the Frequency is set to Weekly.
 */
public data class RecurrencePatternResponse(
    public val expirationDate: String,
    public val frequency: String,
    public val interval: Int? = null,
    public val weekDays: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.RecurrencePatternResponse):
            RecurrencePatternResponse = RecurrencePatternResponse(
            expirationDate = javaType.expirationDate(),
            frequency = javaType.frequency(),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            weekDays = javaType.weekDays().map({ args0 -> args0 }),
        )
    }
}
